/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;

public abstract class FileFormat {
    static final String FORMAT_PACKAGE = "org.eclipse.swt.internal.image";
    static final String FORMAT_SUFFIX = "FileFormat";
    static final String[] FORMATS = new String[]{"WinBMP", "WinBMP", "GIF", "WinICO", "JPEG", "PNG", "TIFF"};
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageLoader loader;
    int compression;

    byte[] bitInvertData(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            byArray[n3] = (byte)(255 - byArray[n3 - n]);
            ++n3;
        }
        return byArray;
    }

    abstract boolean isFileFormat(LEDataInputStream var1);

    abstract ImageData[] loadFromByteStream();

    public ImageData[] loadFromStream(LEDataInputStream lEDataInputStream) {
        try {
            this.inputStream = lEDataInputStream;
            return this.loadFromByteStream();
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    public static ImageData[] load(InputStream inputStream, ImageLoader imageLoader) {
        FileFormat fileFormat = null;
        LEDataInputStream lEDataInputStream = new LEDataInputStream(inputStream);
        boolean bl = false;
        int n = 1;
        while (n < FORMATS.length) {
            if (FORMATS[n] != null) {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.swt.internal.image." + FORMATS[n] + FORMAT_SUFFIX);
                    fileFormat = (FileFormat)clazz.newInstance();
                    if (fileFormat.isFileFormat(lEDataInputStream)) {
                        bl = true;
                        break;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FileFormat.FORMATS[n] = null;
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        if (!bl) {
            SWT.error(42);
        }
        fileFormat.loader = imageLoader;
        return fileFormat.loadFromStream(lEDataInputStream);
    }

    public static void save(OutputStream outputStream, int n, ImageLoader imageLoader) {
        if (n < 0 || n >= FORMATS.length) {
            SWT.error(5);
        }
        if (FORMATS[n] == null) {
            SWT.error(5);
        }
        ImageData imageData = imageLoader.data[0];
        LEDataOutputStream lEDataOutputStream = new LEDataOutputStream(outputStream);
        FileFormat fileFormat = null;
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.image." + FORMATS[n] + FORMAT_SUFFIX);
            fileFormat = (FileFormat)clazz.newInstance();
        }
        catch (Exception exception) {
            SWT.error(5);
        }
        if (n == 1) {
            switch (imageData.depth) {
                case 8: {
                    fileFormat.compression = 1;
                    break;
                }
                case 4: {
                    fileFormat.compression = 2;
                }
            }
        }
        fileFormat.unloadIntoStream(imageData, lEDataOutputStream);
    }

    abstract void unloadIntoByteStream(ImageData var1);

    public void unloadIntoStream(ImageData imageData, LEDataOutputStream lEDataOutputStream) {
        try {
            this.outputStream = lEDataOutputStream;
            this.unloadIntoByteStream(imageData);
            this.outputStream.close();
        }
        catch (Exception exception) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception2) {}
            SWT.error(39, exception);
        }
    }
}

