/*
 * Configuration file
 */

#ifndef CONFIGFILE_H
#define CONFIGFILE_H

char *configfile =
    "# AUTOGENERATED configuration file for wmmclockmon\n"
    "# empty lines or lines begining with # are ignored\n"
    "# booleans can take the next values : 0 1 true false yes no on off\n"
    "# and are case insensitive\n"
    "\n"
    "# Backlight : boolean\n"
    "# Default : Off\n"
    "#\n"
    "Backlight = %s\n"
    "\n"
    "# Color : string (backlight color when backlight is ON)\n"
    "# Default : #6ec63b\n"
    "#\n"
    "Color = %s\n"
    "\n"
    "# Command : string (what to do when alarm raises)\n"
    "# Default : nothing\n"
    "#\n"
    "Command = %s\n"
    "\n"
    "# MessageCmd : string (what to do when alarm raises and there is a message)\n"
    "# Default : nothing\n"
    "#\n"
    "MessageCmd = %s\n"
    "\n"
    "# Blinking enable : boolean\n"
    "# Default : yes\n"
    "#\n"
    "Blink = %s\n"
    "\n"
    "# H12 : boolean (12 hour clock)\n"
    "# Default : false\n"
    "H12 = %s\n"
    "\n"
    "# TimeMode : integer (0: normal clock, 1: internet time, 2: binary clock)\n"
    "# Default : 0\n"
    "TimeMode = %d\n"
    "\n"
    "# Locale : boolean (use current locale or not)\n"
    "# Default : Yes\n"
    "Locale = %s\n"
    "\n"
    "# StyleDir : string (name of styles directory)\n"
    "# Default : nothing\n"
    "#\n"
    "StyleDir = %s\n"
    "\n"
    "# Style : string (name of style -- without extension)\n"
    "# Default : nothing\n"
    "#\n"
    "Style = %s\n"
    "\n"
    "# ShowCal : boolean (display calendar at startup / 00:00)\n"
    "# Default : no\n"
    "#\n"
    "ShowCal = %s\n"
    "\n"
    "# CalAlrms : boolean (look for alarms in calendar for today -- see manpage)\n"
    "# Default : off\n"
    "#\n"
    "CalAlrms = %s\n"
    "\n"
    "# Alarm : string ([on|off@]HH:MM[-#DAY][.MESSAGE])\n"
    "# Default : nothing\n"
    "#   on|off  boolean describing the state of the alarm\n"
    "#   @       field separator between status and time - DON'T PUT SPACES\n"
    "#   HH:MM   time when you want the alarm to be raised\n"
    "#   -       field separator between time and day - DON'T PUT SPACES\n"
    "#   #DAY    day of the week (1-7)\n"
    "#   .       field separator between time or day and the message\n"
    "#   MESSAGE message you wantto be displayed (see MessageCmd) when this\n"
    "#           alarm raises\n"
    "#\n"
    "# use as many Alarm options as you want alarms\n"
    "#\n";


/*                         On@HM-?D?.?M?*/
char *alarmline = "Alarm = %s@%s%s%s%s%s\n";

#endif

