/*
DateTimeUtils.cc
*/

#include "DateTimeUtils.h"
#include "Language.h"

extern Language *L;

int CurrentYear (void)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  return xtm->tm_year + 1900;
  }

int CurrentMonth (void)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  return xtm->tm_mon;            
  }

int CurrentDay (void)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  return xtm->tm_mday;
  }
  
int DayOfWeek (long julianDay) 
  {
  return (int)(julianDay % 7L);
  }

bool IsLeapYear (int year)
  { 
  return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0); 
  }

//The first month is 0 (January)
int DaysOfMonth (int amonth, int ayear)
  {
  const int daynumbers[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }; 
  int days;
  days = daynumbers [amonth];
  //Adjust the number of days in February based on whether or not it's a leap year.
  if (IsLeapYear (ayear) && (amonth == 1))
    {
    ++days;
    }
  return days;  
  }
  
long GregorianToJulian(int day, int month, int year)
  {
  return (long)day - 32075L + 1461L *
    ((long)year + 4800L + ((long)month - 14L) / 12L) / 4L + 367L * 
    ((long)month - 2L - ((long)month - 14L) / 12L * 12L) / 12L - 3L *
    (((long)year + 4900L + ((long)month - 14L) / 12L) / 100L) / 4L;
  }

void JulianToGregorian (long julianDay, int& day, int& month, int& year)
  {
  long a = julianDay + 68569L;
  long b = 4L * a / 146097L;
  a = a - (146097L * b + 3L) / 4L;
  long c = 4000L * (a + 1) / 1461001L;
  a = a - 1461L * c / 4L + 31;
  long d = 80L * a / 2447L;
  day = (int)(a - 2447L * d / 80L);
  a = d / 11L;
  month = (int)(d + 2L - 12L * a);
  year = (int)(100L * (b - 49L) + c + a);
  }

const char *getLongMonth (int amonth)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (amonth)
        {
        case 0: return "January"; break;
        case 1: return "February"; break;
        case 2: return "March"; break;
        case 3: return "April"; break;
        case 4: return "May"; break;
        case 5: return "June"; break;
        case 6: return "July"; break;
        case 7: return "August"; break;
        case 8: return "September"; break;
        case 9: return "October"; break;
        case 10: return "November"; break;
        case 11: return "December"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (amonth)
        {
        case 0: return "Enero"; break;
        case 1: return "Febrero"; break;
        case 2: return "Marzo"; break;
        case 3: return "Abril"; break;
        case 4: return "Mayo"; break;
        case 5: return "Junio"; break;
        case 6: return "Julio"; break;
        case 7: return "Agosto"; break;
        case 8: return "Septiembre"; break;
        case 9: return "Octubre"; break;
        case 10: return "Noviembre"; break;
        case 11: return "Diciembre"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (amonth)
        {
        case 0: return "Gener"; break;
        case 1: return "Febrer"; break;
        case 2: return "Mar&ccedil;"; break;
        case 3: return "Abril"; break;
        case 4: return "Maig"; break;
        case 5: return "Juny"; break;
        case 6: return "Juliol"; break;
        case 7: return "Agost"; break;
        case 8: return "Setembre"; break;
        case 9: return "Octubre"; break;
        case 10: return "Novembre"; break;
        case 11: return "Desembre"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (amonth)
        {
        case 0: return "January"; break;
        case 1: return "February"; break;
        case 2: return "March"; break;
        case 3: return "April"; break;
        case 4: return "May"; break;
        case 5: return "June"; break;
        case 6: return "July"; break;
        case 7: return "August"; break;
        case 8: return "September"; break;
        case 9: return "October"; break;
        case 10: return "November"; break;
        case 11: return "December"; break;
        default: {return "error_no_month"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }  
     
const char *getShortMonth (int amonth)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (amonth)
        {
        case 0: return "Jan"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Apr"; break;
        case 4: return "May"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Aug"; break;
        case 8: return "Sep"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Dec"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (amonth)
        {
        case 0: return "Ene"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Abr"; break;
        case 4: return "May"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Ago"; break;
        case 8: return "Sep"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Dic"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (amonth)
        {
        case 0: return "Gen"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Abr"; break;
        case 4: return "Mai"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Ago"; break;
        case 8: return "Set"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Des"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (amonth)
        {
        case 0: return "Jan"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Apr"; break;
        case 4: return "May"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Aug"; break;
        case 8: return "Sep"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Dec"; break;
        default: {return "error_no_month"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }     

const char *getLongDay (int aday)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (aday)
        {
        case 0: return "Sunday"; break;
        case 1: return "Monday"; break;
        case 2: return "Tuesday"; break;
        case 3: return "Wednesday"; break;
        case 4: return "Thursday"; break;
        case 5: return "Friday"; break;
        case 6: return "Saturday"; break;
        case 7: return "Sunday"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (aday)
        {
        case 0: return "Domingo"; break;
        case 1: return "Lunes"; break;
        case 2: return "Martes"; break;
        case 3: return "Mi&eacute;rcoles"; break;
        case 4: return "Jueves"; break;
        case 5: return "Viernes"; break;
        case 6: return "S&aacute;bado"; break;
        case 7: return "Domingo"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (aday)
        {
        case 0: return "diumenge"; break;
        case 1: return "dilluns"; break;
        case 2: return "dimarts"; break;
        case 3: return "dimecres"; break;
        case 4: return "dijous"; break;
        case 5: return "divendres"; break;
        case 6: return "dissabte"; break;
        case 7: return "diumenge"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (aday)
        {                 
        case 0: return "Sunday"; break;
        case 1: return "Monday"; break;
        case 2: return "Tuesday"; break;
        case 3: return "Wednesday"; break;
        case 4: return "Thursday"; break;
        case 5: return "Friday"; break;
        case 6: return "Saturday"; break;
        case 7: return "Sunday"; break;
        default: {return "error_no_day"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }  

const char *getShortDay3 (int aday)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (aday)
        {
        case 0: return "Sun"; break;
        case 1: return "Mon"; break;
        case 2: return "Tue"; break;
        case 3: return "Wed"; break;
        case 4: return "Thu"; break;
        case 5: return "Fri"; break;
        case 6: return "Sat"; break;
        case 7: return "Sun"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (aday)
        {
        case 0: return "Dom"; break;
        case 1: return "Lun"; break;
        case 2: return "Mar"; break;
        case 3: return "Mie"; break;
        case 4: return "Jue"; break;
        case 5: return "Vie"; break;
        case 6: return "Sab"; break;
        case 7: return "Dom"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (aday)
        {
        case 0: return "diu"; break;
        case 1: return "dil"; break;
        case 2: return "dim"; break;
        case 3: return "dim"; break;
        case 4: return "dij"; break;
        case 5: return "div"; break;
        case 6: return "dis"; break;
        case 7: return "diu"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (aday)
        {                 
        case 0: return "Sun"; break;
        case 1: return "Mon"; break;
        case 2: return "Tue"; break;
        case 3: return "Wed"; break;
        case 4: return "Thu"; break;
        case 5: return "Fri"; break;
        case 6: return "Sat"; break;
        case 7: return "Sun"; break;
        default: {return "error_no_day"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }  
  
const char *getShortDay2 (int aday)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (aday)
        {
        case 0: return "Su"; break;
        case 1: return "Mo"; break;
        case 2: return "Tu"; break;
        case 3: return "We"; break;
        case 4: return "Th"; break;
        case 5: return "Fr"; break;
        case 6: return "Sa"; break;
        case 7: return "Su"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (aday)
        {
        case 0: return "Do"; break;
        case 1: return "Lu"; break;
        case 2: return "Ma"; break;
        case 3: return "Mi"; break;
        case 4: return "Ju"; break;
        case 5: return "Vi"; break;
        case 6: return "Sa"; break;
        case 7: return "Do"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (aday)
        {
        case 0: return "dg"; break;
        case 1: return "dl"; break;
        case 2: return "dm"; break;
        case 3: return "dc"; break;
        case 4: return "dj"; break;
        case 5: return "dv"; break;
        case 6: return "ds"; break;
        case 7: return "dg"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (aday)
        {                 
        case 0: return "Su"; break;
        case 1: return "Mo"; break;
        case 2: return "Tu"; break;
        case 3: return "We"; break;
        case 4: return "Th"; break;
        case 5: return "Fr"; break;
        case 6: return "Sa"; break;
        case 7: return "Su"; break;
        default: {return "error_no_day"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }    
  
  
  
  
  
