//
// C++ Interface: aptpackages
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __APTPACKAGES_H_2004_04_03
#define __APTPACKAGES_H_2004_04_03

#include <string>

#include <apt-pkg/pkgcachegen.h>
#include <apt-pkg/init.h>
#include <apt-pkg/progress.h>
#include <apt-pkg/sourcelist.h>

#include "cacheaccess.h"
#include "iaptsearch.h"

using namespace std;


// Some help from synaptics:
//     pkgCache::PkgIterator->CurrentVer().VerStr()
//     
//     pkgDepCache::StateCache &State = (*_depcache)[*_package];
//     if (State.CandidateVer == 0)
//         return NULL;
//     return State.CandidateVerIter(*_depcache).VerStr();

// INFORMATION taken from synaptic common/rpackage.cc
// there is an example of an installed filelist (RPackage::installedFiles())

namespace NApt
{

/** @brief This class reads the apt cachefile and allows access to the packages.
  *
  * @author Benjamin Mesing
  */
class AptPackages : public IAptSearch
{
	MMap *_pMap;
	pkgCache *_pGCache;

	/** Structure that extends the apt pkgCache::VerFile class.  Taken from apt-cache.*/
	struct ExVerFile
	{
		ExVerFile() : Vf(0), NameMatch(false) {}
		pkgCache::VerFile *Vf;
		bool NameMatch;
	};
public:
	AptPackages(const CacheAccess& ca);
	~AptPackages();
	/** @brief Searches for the given pattern in the package database.
	  * @param result the set where the search result should be inserted. The names of the matching packages 
	  * will be added to result.
	  * @param pattern pattern to search for. This should be a regular expression
	  * @param searchDescr defines if the description should be searched too, else only the
	  * names will be searched
	  * @returns if at least one package was found.
	  */
	bool search(Tagcoll::OpSet<string>& result, const string& pattern, bool searchDescr=true);
	/** @brief Searches for the given patterns in the package database.
	  *
	  * For a package it is neccessary to match all expressions from the given pattern list.
	  * @param result the set where the search result should be inserted. The names of the matching packages 
	  * will be added to result.
	  * @param handleMaker the handle maker to be used for this search - it maps the strings to the
	  * integer values. 
	  * @param patterns list of patterns to be searched. The compare happens case insensitive.
	  * @param searchDescr defines if the description should be searched too, else only the
	  * names will be serached
	  * @returns if at least one package was found.
	  * @pre !patterns.empty()
	  */
	bool search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const vector<string>& patterns, bool searchDescr=true);
	/** @brief Searches for the given pattern in the package database.
	  * @param result the set where the search result should be inserted. The names of the matching packages 
	  * will be added to result.
	  * @param handleMaker the handle maker to be used for this search - it maps the strings to the
	  * integer values. 
	  * @param pattern the patterns to be searched. The compare happens case insensitive.
	  * @param searchDescr defines if the description should be searched too, else only the
	  * names will be serached
	  * @returns if at least one package was found.
	  */
	bool search(Tagcoll::OpSet<int>& result, Tagcoll::HandleMaker<string>& handleMaker, 
		const string& pattern, bool searchDescr=true);

	/** @brief maps the package names to the short descriptions reading the whole apt database.
	  *
	  * @param result the map to fill.
	  * @param handleMaker the handleMaker to be used. 
	  * 
	  * This function might throw an AptException. */
//	bool pkgNamesToShortDesc(map<int, string>& result, Tagcoll::HandleMaker<string>& handleMaker);
};

}	// namespace NApt

#endif	//  __APTPACKAGES_H_2004_04_03
