//
// C++ Interface: exception
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef __EXCEPTION_H_2004_06_15
#define __EXCEPTION_H_2004_06_15

#include <string>

using namespace std;

namespace NException {

/** Base class for custom exceptions.
  * 
  * @author Benjamin Mesing
  */
class Exception{
public:
	Exception();
	virtual ~Exception();
	/** @returns a string descibing the problem. */
	virtual string description()=0;
};

/** Class that stores the error message in a simple string.
  * 
  * @author Benjamin Mesing
  */
class SimpleString : virtual public Exception
{
	string _description;
public:
	/** Create an exception containing a simple string. */
	SimpleString(const string& description)	{ _description = description; }
	virtual string description()	{ return _description; }
};

/** Errors which results from wrong code - which are not caused by user interaction. */
class ProgrammerError : virtual public Exception
{
};

/** Errors which results from user interaction. */
class RuntimeError : virtual public Exception
{
};


};

#endif	//  __EXCEPTION_H_2004_06_15
