import sys
import time
import platform
try:
    from wxPython.wx import *
except ImportError:
    print "\n\nImporting wxPython Failed! You must install wxPython for OpenRPG to run"
    print "Download the latest version here: http://www.openrpg.com/orpgnuke/modules.php?name=GetORPG"

class system_check:

    def start(self,log_file='openrpg_sysinfo.txt'):
        self.log_file = open(log_file,'w')
        self.log_file.write("OpenRPG System Info " + time.strftime( '%d-%m-%y', time.localtime( time.time() ) ))
        self.check_py()
        self.check_wxpython()
        self.check_platform()
        self.log_file.close()

    def check_wxpython(self):
        self.log_file.write("\nwxPython Version: " + wx.__version__)

    def check_py(self):
        self.log_file.write("\nPython: " + sys.version)

    def check_platform(self):
        self.log_file.write("\nPlatform: " + platform.platform())


if __name__ == "__main__":
    syscheck = system_check()
    syscheck.start()
