# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/whiteboard_msg.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: whiteboard_msg.py,v 1.4 2002/06/10 01:12:37 markt1964 Exp $
#
# Description: This file contains some of the basic definitions for the chat
# utilities in the orpg project.
#
__version__ = "$Id: whiteboard_msg.py,v 1.4 2002/06/10 01:12:37 markt1964 Exp $"

from base_msg import *

class line_msg(map_element_msg_base):

    def __init__(self,reentrant_lock_object = None):
        self.tagname = "line"   # set this to be for lines.  Tagname gets used in some base class functions.
        map_element_msg_base.__init__(self,reentrant_lock_object)   # call base class



    # convenience method to use if only this line is modified
    #   outputs a <map/> element containing only the changes to this line
    def standalone_update_text(self,update_id_string):
        buffer = "<map id='" + update_id_string + "'>"
        buffer += "<whiteboard>"
        buffer += self.get_changed_xml()
        buffer += "</whiteboad></map>"
        return buffer

    # convenience method to use if only this line is modified
    #   outputs a <map/> element that deletes this line
    def standalone_delete_text(self,update_id_string):
        buffer = None

        if self._props.has_key("id"):
            buffer = "<map id='" + update_id_string + "'>"
            buffer += "<whiteboard>"
            buffer += "<line action='del' id='" + self._props("id") + "'/>"
            buffer += "</whiteboard></map>"

        return buffer

    # convenience method to use if only this line is modified
    #   outputs a <map/> element to add this line
    def standalone_add_text(self,update_id_string):
        buffer = "<map id='" + update_id_string + "'>"
        buffer += "<whiteboard>"
        buffer += self.get_all_xml()
        buffer += "</whiteboard></map>"
        return buffer

    def get_all_xml(self,action="new",output_action=1):
        return map_element_msg_base.get_all_xml(self,action,output_action)

    def get_changed_xml(self,action="update",output_action=1):
        return map_element_msg_base.get_changed_xml(self,action,output_action)



class whiteboard_msg(map_element_msg_base):

    def __init__(self,reentrant_lock_object = None):
        self.tagname = "whiteboard"
        map_element_msg_base.__init__(self,reentrant_lock_object)

    def init_from_dom(self,xml_dom):
        self.p_lock.acquire()
        print xml_dom.getAttributeKeys()
        if xml_dom.tagName == self.tagname:
            if xml_dom.getAttributeKeys():
                for k in xml_dom.getAttributeKeys():
                    self.init_prop(k,xml_dom.getAttribute(k))

            for c in xml_dom._get_childNodes():
                line = line_msg(self.p_lock)

                try:
                    line.init_from_dom(c)
                except Exception, e:
                    print e
                    continue

                id = line.get_prop("id")
                action = line.get_prop("action")


                if action == "new":
                    self.children[id] = line

                elif action == "del":
                    if self.children.has_key(id):
                        self.children[id] = None
                        del self.children[id]

                elif action == "update":
                    if self.children.has_key(id):
                        self.children[id].init_props(line.get_all_props())

        else:
            self.p_lock.release()
            raise Exception, "Error attempting to initialize a " + self.tagname + " from a non-<" + self.tagname + "/> element"
        self.p_lock.release()



    def set_from_dom(self,xml_dom):
        self.p_lock.acquire()
        if xml_dom.tagName == self.tagname:
            if xml_dom.getAttributeKeys():
                for k in xml_dom.getAttributeKeys():
                    self.set_prop(k,xml_dom.getAttribute(k))

            for c in xml_dom._get_childNodes():
                line = line_msg(self.p_lock)

                try:
                    print "setting from dom"
                    line.set_from_dom(c)
                except Exception, e:
                    print e
                    continue

                id = line.get_prop("id")
                action = line.get_prop("action")

                if action == "new":
                    self.children[id] = line

                elif action == "del":
                    if self.children.has_key(id):
                        self.children[id] = None
                        del self.children[id]

                elif action == "update":
                    if self.children.has_key(id):
                        self.children[id].set_props(line.get_all_props())

        else:
            self.p_lock.release()
            raise Exception, "Error attempting to set a " + self.tagname + " from a non-<" + self.tagname + "/> element"
        self.p_lock.release()


