# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: forms.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: forms.py,v 1.26 2003/11/19 06:53:50 tdb30_ Exp $
#
# Description: The file contains code for the form based nodehanlers
#

__version__ = "$Id: forms.py,v 1.26 2003/11/19 06:53:50 tdb30_ Exp $"

from containers import *

#################################
## form container
#################################

class form_handler(container_handler):
    """ 
    	<nodehandler name='?'  module='forms' class='form_handler'  >
    	<form width='100' height='100' />
    	</nodehandler>
    """
    
    def __init__(self,xml_dom,tree_node,openrpg):
        container_handler.__init__(self,xml_dom,tree_node,openrpg)

    def load_children(self):
        self.atts = None
        children = self.master_dom._get_childNodes()
        for c in children:
            if c._get_tagName() == "form":
                self.atts = c
            else:
                self.tree.load_xml(c,self.mytree_node)
        if not self.atts:
           elem = minidom.Element('form')
           elem.setAttribute("width","400")
           elem.setAttribute("height","600")
           self.atts = self.master_dom.appendChild(elem)
           
    
        
    def get_design_panel(self,parent):
        return form_edit_panel(parent,self)    

    def get_use_panel(self,parent):
        return form_panel(parent,self)
        
    def on_drop(self,evt):
        # make sure its a contorl node
        container_handler.on_drop(self,evt)
     

class form_panel(wxScrolledWindow):
    def __init__(self, parent, handler):
        wxScrolledWindow.__init__(self, parent, -1,style=wxVSCROLL | wxSUNKEN_BORDER  )
        self.height = int(handler.atts.getAttribute("height"))
        self.SetScrollbars(10, 10,80, self.height/10)
        self.handler = handler
        #self.parent = parent
        self.main_sizer = wxBoxSizer(wxVERTICAL)
        self.panels = {}

        tree = self.handler.tree
        maximum = tree.GetChildrenCount(handler.mytree_node,0)
        cookie = 0
        (child,cookie)=tree.GetFirstChild(handler.mytree_node,cookie)
        obj = tree.GetPyData(child)
        for m in range(maximum):
            panel = obj.get_use_panel(self)
            name = obj.master_dom.getAttribute("name")
            size = obj.get_size_constraint()
            if panel:
                panel.SetSize(wxSize(100,25)) # makes sure the window hs height
                self.main_sizer.Add(panel, size, wxEXPAND)
                self.main_sizer.Add(10,10)
            if m < maximum-1:
                child = tree.GetNextSibling(child)
                obj = tree.GetPyData(child)
        self.SetSizer(self.main_sizer)
        EVT_SIZE(self, self.on_size)

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.SetScrollbars(10, 10,s[0]/10, self.height/10)
        dc = wxClientDC(self)
        x = dc.DeviceToLogicalX(0)
        y = dc.DeviceToLogicalY(0)      
        self.main_sizer.SetDimension(x+10,y+10,s[0]-30,self.height-20)     
        evt.Skip()
        
F_HEIGHT = wxNewId()
F_WIDTH = wxNewId()
class form_edit_panel(wxBoxedSizer):
    def __init__(self, parent, handler):
        wxBoxedSizer.__init__(self, parent, "Form Properties")
        self.handler = handler
        sizer = wxBoxSizer(wxVERTICAL)
        wh_sizer = wxBoxSizer(wxHORIZONTAL)
        self.text = {   P_TITLE : orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name')),
                        F_HEIGHT : orpgTextCtrl(self, F_HEIGHT, handler.atts.getAttribute('height')),
                        F_WIDTH : orpgTextCtrl(self, F_WIDTH, handler.atts.getAttribute('width'))
                      }
                      
        wh_sizer.Add(wxStaticText(self, -1, "Width:"), 0, wxALIGN_CENTER)                      
        wh_sizer.Add(10,10)
        wh_sizer.Add(self.text[F_WIDTH], 0, wxEXPAND)
        wh_sizer.Add(10,10)
        wh_sizer.Add(wxStaticText(self, -1, "Height:"), 0, wxALIGN_CENTER)                     
        wh_sizer.Add(10,10)
        wh_sizer.Add(self.text[F_HEIGHT], 0, wxEXPAND)
                      
        sizer.Add(wxStaticText(self, -1, "Title:"), 0, wxEXPAND)
        sizer.Add(self.text[P_TITLE], 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(wh_sizer,0,wxEXPAND)

#        self.box_sizer = wxBoxedSizer( self, "Form Properties" )
        self.set_sizer(sizer)

 #       EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, P_TITLE, self.on_text)
        EVT_TEXT(self, F_HEIGHT, self.on_text)
        EVT_TEXT(self, F_WIDTH, self.on_text)

    def on_text(self,evt):
        id = evt.GetId()
        txt = self.text[id].GetValue()
        if not len(txt): return
        if id == P_TITLE:
            self.handler.master_dom.setAttribute('name',txt)
            self.handler.rename(txt)
        elif id == F_HEIGHT or id == F_WIDTH:
            try:
                int(txt)
            except:
                return 0
            if id == F_HEIGHT:
                self.handler.atts.setAttribute("height",txt)
            elif id == F_WIDTH:
                self.handler.atts.setAttribute("width",txt)                          




        
##########################       
## control handler
##########################
class control_handler(node_handler):
    """ A nodehandler for form controls.
        <nodehandler name='?' module='forms' class='control_handler' />               
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        
    def get_size_constraint(self):
        return 0
        
        
##########################       
## textctrl handler
##########################
    #
    # Updated by Snowdog (April 2003)
    #   Now includes Raw Send Mode (like the chat macro uses)
    #   and an option to remove the title from text when sent
    #   to the chat in the normal non-chat macro mode.
    #
class textctrl_handler(node_handler):
    """ <nodehandler class="textctrl_handler" module="form" name="">			
	   <text multiline='0' send_button='0' raw_mode='0' hide_title='0'>Text In Node</text>
	</nodehandler>
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.text_elem = self.master_dom.getElementsByTagName('text')[0]
        self.text = safe_get_text_node(self.text_elem)
        if self.text_elem.getAttribute("send_button") == "":
            self.text_elem.setAttribute("send_button","0")
        if self.text_elem.getAttribute("raw_mode") == "":
            self.text_elem.setAttribute("raw_mode","0")
        if self.text_elem.getAttribute("hide_title") == "":
            self.text_elem.setAttribute("hide_title","0")

    def get_design_panel(self,parent):
        return textctrl_edit_panel(parent,self)    
        
    def get_use_panel(self,parent):
        return text_panel(parent,self)
    
    def get_size_constraint(self):
        return int(self.text_elem.getAttribute("multiline"))
      
    def is_multi_line(self):
        return int(self.text_elem.getAttribute("multiline"))
    
    def is_raw_send(self):
        return int(self.text_elem.getAttribute("raw_mode"))
    
    def is_hide_title(self):
        return int(self.text_elem.getAttribute("hide_title"))

    def has_send_button(self):
        return int(self.text_elem.getAttribute("send_button"))       
    

    def tohtml(self):
        txt = self.text._get_nodeValue()
        txt = string.replace(txt,'\n',"<br>")
        if not self.is_hide_title():
            txt = "<b>"+self.master_dom.getAttribute("name")+":</b> "+txt
        return txt
        
        
FORM_TEXT_CTRL = wxNewId()
FORM_SEND_BUTTON = wxNewId()
        
class text_panel(wxPanel):
    def __init__(self, parent, handler):
        wxPanel.__init__(self, parent, -1)
        self.chat = handler.chat
        self.handler = handler        
        if handler.is_multi_line(): 
            text_style = wxTE_MULTILINE 
            sizer_style = wxEXPAND
            sizer = wxBoxSizer(wxVERTICAL)                     
        else:
            sizer_style = wxALIGN_CENTER
            text_style = 0 
            sizer = wxBoxSizer(wxHORIZONTAL)
	    
        txt = handler.text._get_nodeValue()
        self.text = orpgTextCtrl(self, FORM_TEXT_CTRL, txt,style=text_style)
        sizer.Add(wxStaticText(self, -1, handler.master_dom.getAttribute('name')+": "), 0, sizer_style)
        sizer.Add(5,0)     
        sizer.Add(self.text, 1, sizer_style)       
      
        if handler.has_send_button():
            sizer.Add(wxButton(self, FORM_SEND_BUTTON, "Send"), 0, sizer_style)

        self.sizer = sizer
        self.SetSizer(sizer)
        EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, FORM_TEXT_CTRL, self.on_text)
        EVT_BUTTON(self, FORM_SEND_BUTTON, self.on_send)

    def on_text(self,evt):
        txt = self.text.GetValue()
        txt = strip_text(txt)
        self.handler.text._set_nodeValue(txt)
       #print txt
        
    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.sizer.SetDimension(0,0,s[0],s[1])

    def on_send(self,evt):
        txt = self.text.GetValue()
        if not self.handler.is_raw_send():
            #self.chat.ParsePost(self.tohtml(),true,true)
            self.chat.ParsePost(self.chat.colorize(self.chat.mytextcolor, self.handler.tohtml()),true,true)
            return 1
        actionlist = txt.split("\n")
        for line in actionlist:
            if(line != ""):
                if line[0] != "/": ## it's not a slash command
                    self.chat.ParsePost(self.chat.colorize(self.chat.mytextcolor, line),true,true)
                else:
                    action = line
                    self.chat.chat_cmds.docmd(action)
        return 1

F_MULTI = wxNewId()
F_SEND_BUTTON = wxNewId()
F_RAW_SEND = wxNewId()
F_HIDE_TITLE = wxNewId()
F_TEXT = wxNewId()

class textctrl_edit_panel(wxBoxedSizer):
    def __init__(self, parent, handler):
        wxBoxedSizer.__init__(self, parent, "Text Properties")
        self.handler = handler
        sizer = wxBoxSizer(wxVERTICAL)
       	
        self.title = orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name'))
        self.multi = wxCheckBox(self, F_MULTI, " Multi-Line")
        self.multi.SetValue(handler.is_multi_line())
        self.raw_send = wxCheckBox(self, F_RAW_SEND, " Send as Macro")
        self.raw_send.SetValue(handler.is_raw_send())
        self.hide_title = wxCheckBox(self, F_HIDE_TITLE, " Hide Title")
        self.hide_title.SetValue(handler.is_hide_title())
        self.send_button = wxCheckBox(self, F_SEND_BUTTON, " Send Button")
        self.send_button.SetValue(handler.has_send_button())
        
        sizer.Add(wxStaticText(self, P_TITLE, "Title:"), 0, wxEXPAND)
        sizer.Add(self.title, 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(self.multi, 0, wxEXPAND)
        sizer.Add(self.raw_send, 0, wxEXPAND)
        sizer.Add(self.hide_title, 0, wxEXPAND)
        sizer.Add(self.send_button, 0 , wxEXPAND)
        sizer.Add(10,10)
        if handler.is_multi_line():
            sizer_style = wxEXPAND
            text_style = wxTE_MULTILINE
            multi = 1
        else:
            sizer_style = wxEXPAND
            text_style = 0
            multi = 0
        self.text = orpgTextCtrl(self, F_TEXT, handler.text._get_nodeValue(),style=text_style)
        sizer.Add(5,0)     
        sizer.Add(self.text, multi, sizer_style)
        self.set_sizer(sizer)
        EVT_TEXT(self, P_TITLE, self.on_text)
        EVT_TEXT(self, F_TEXT, self.on_text)
        EVT_CHECKBOX(self, F_MULTI, self.on_button)
        EVT_CHECKBOX(self, F_RAW_SEND, self.on_raw_button)
        EVT_CHECKBOX(self, F_HIDE_TITLE, self.on_hide_button)
        EVT_CHECKBOX(self, F_SEND_BUTTON, self.on_send_button)
	
    def on_text(self,evt):
        id = evt.GetId()
        if id == P_TITLE:
            txt = self.title.GetValue()
            if not len(txt): return
            self.handler.master_dom.setAttribute('name',txt)
            self.handler.rename(txt)
        if id == F_TEXT:
            txt = self.text.GetValue()
            txt = strip_text(txt)
            self.handler.text._set_nodeValue(txt)

    def on_button(self,evt):
        self.handler.text_elem.setAttribute("multiline",str(evt.Checked()))

    def on_raw_button(self,evt):
        self.handler.text_elem.setAttribute("raw_mode",str(evt.Checked()))

    def on_hide_button(self,evt):
        self.handler.text_elem.setAttribute("hide_title",str(evt.Checked()))

    def on_send_button(self,evt):
        self.handler.text_elem.setAttribute("send_button",str(evt.Checked()))





        
#######################
## listbox handler
#######################
    #
    # Updated by Snowdog (April 2003)
    #   Now includesan option to remove the title from 
    #   text when sent to the chat.
    #
L_DROP = 0
L_LIST = 1
L_RADIO = 2
L_CHECK = 3
L_ROLLER = 4

class listbox_handler(node_handler):
    """
    <nodehandler class="listbox_handler" module="forms" name="">
        <list type="1"  send_button='0' hide_title='0'>
		<option value="" selected="" >Option Text I</option>
		<option value="" selected="" >Option Text II</option>
        </list>    
    </nodehandler>
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)         
        self.list = self.master_dom.getElementsByTagName('list')[0]
        self.options = self.list.getElementsByTagName('option')
        if self.list.getAttribute("send_button") == "":
            self.list.setAttribute("send_button","0")
        if self.list.getAttribute("hide_title") == "":
            self.list.setAttribute("hide_title","0")

    def get_design_panel(self,parent):
        return listbox_edit_panel(parent,self)    
        
    def get_use_panel(self,parent):
        return listbox_panel(parent,self)

    def get_type(self):
        return int(self.list.getAttribute("type"))
        
    def set_type(self,type):
        self.list.setAttribute("type",str(type))

    def is_hide_title(self):
        return int(self.list.getAttribute("hide_title"))
    
    # single selection methods
    def get_selected_node(self):
        for opt in self.options:
            if opt.getAttribute("selected") == "1": return opt
        return None       
    
    def get_selected_index(self):
        i = 0
        for opt in self.options:
            if opt.getAttribute("selected") == "1": 
                return i
            i += 1
        return 0
        
    def get_selected_text(self):
        node = self.get_selected_node()
        if node:
            return safe_get_text_node(node)._get_nodeValue()
        else:
            return ""                   
    
        
    # mult selection methods
    
    def get_selections(self):
        opts = []
        for opt in self.options:
            if opt.getAttribute("selected") == "1":
                opts.append(opt)
        return opts
    
    def get_selections_text(self):
        opts = []
        for opt in self.options:
            if opt.getAttribute("selected") == "1":
                opts.append(safe_get_text_node(opt)._get_nodeValue())
        return opts

    def get_selections_index(self):
        opts = []
        i = 0
        for opt in self.options:
            if opt.getAttribute("selected") == "1":                
                opts.append(i)
            i += 1
        return opts

    # setting selection method   
    
    def set_selected_node(self,index,selected=1):
        if self.get_type() != L_CHECK:
            self.clear_selections()
        self.options[index].setAttribute("selected",str(selected))
    
    def clear_selections(self):
        for opt in self.options:
            opt.setAttribute("selected","0")        
       
    # misc methods
        
    def get_options(self):
        opts = []
        for opt in self.options:
            opts.append(safe_get_text_node(opt)._get_nodeValue())
        return opts      

    def get_option(self,index):
        return safe_get_text_node(self.options[index])._get_nodeValue()        
    
    def add_option(self,opt):
        elem = minidom.Element('option')
        elem.setAttribute("value","0")
        elem.setAttribute("selected","0")
        t_node = minidom.Text(opt)
        t_node = elem.appendChild(t_node)
        self.list.appendChild(elem)
        self.options = self.list.getElementsByTagName('option')       
       
    def remove_option(self,index):        
        self.list.removeChild(self.options[index])         
        self.options = self.list.getElementsByTagName('option')
        
    def edit_option(self,index,value):
        safe_get_text_node(self.options[index])._set_nodeValue(value)       

    def has_send_button(self):
        return int(self.list.getAttribute("send_button"))

    def get_size_constraint(self):
        if self.get_type() == L_DROP:
            return 0
        else:
            return 1

    def tohtml(self):
        opts = self.get_selections_text()
        text = ""
        if not self.is_hide_title():
            text = "<b>"+self.master_dom.getAttribute("name")+":</b> "
        comma = ", "
        text += comma.join(opts)        
        return text
        
    
        
F_LIST = wxNewId()
F_SEND = wxNewId()


class listbox_panel(wxPanel):
    def __init__(self, parent, handler):
        wxPanel.__init__(self, parent, -1)
        self.handler = handler                
        self.chat = handler.chat
        opts = handler.get_options()
        cur_opt = handler.get_selected_text()
        type = handler.get_type()
        label = handler.master_dom.getAttribute('name')

        if type == L_DROP:
            self.list = wxComboBox(self,F_LIST,cur_opt,choices=opts,style=wxCB_READONLY)
        elif type == L_LIST:
            self.list = wxListBox(self,F_LIST,choices=opts)
        elif type == L_RADIO:
            self.list = wxRadioBox(self,F_LIST,label,choices=opts,majorDimension=3)
        elif type == L_CHECK:
            self.list = wxCheckListBox(self,F_LIST,choices=opts)
            self.set_checks()
            
        for i in handler.get_selections_text():
            if type == L_DROP:
                self.list.SetValue( i )
            else:
                self.list.SetStringSelection( i )   

        if type==L_DROP:
            sizer = wxBoxSizer(wxHORIZONTAL)
            sizer_style = wxALIGN_CENTER
        else:
            sizer = wxBoxSizer(wxVERTICAL)
            sizer_style = wxEXPAND

        if type != L_RADIO:
            sizer.Add(wxStaticText(self, -1, label+": "), 0, sizer_style)
            sizer.Add(5,0)
            
        sizer.Add(self.list, 1, sizer_style)       

        if handler.has_send_button():
            sizer.Add(wxButton(self, F_SEND, "Send"), 0, sizer_style)
            EVT_BUTTON(self, F_SEND, self.handler.on_send_to_chat)

        self.sizer = sizer        
        EVT_SIZE(self, self.on_size)
        self.SetSizer(sizer)
        
        if type == L_DROP:
            EVT_COMBOBOX(self,F_LIST,self.on_change)
        elif type == L_LIST:
            EVT_LISTBOX(self,F_LIST,self.on_change)
        elif type == L_RADIO:
            EVT_RADIOBOX(self,F_LIST,self.on_change)
        elif type == L_CHECK:
            EVT_CHECKLISTBOX(self,F_LIST,self.on_check)
        
            
        self.type = type
        
        #EVT_TEXT(self, FORM_TEXT_CTRL, self.on_text)        

    def on_change(self,evt):
        #print "selected:" + str(self.list.GetSelection())
        self.handler.set_selected_node(self.list.GetSelection())

    def on_check(self,evt):
        for i in range(self.list.Number()):
            self.handler.set_selected_node(i,self.list.IsChecked(i))
            
    def set_checks(self):
        for i in self.handler.get_selections_index():
            self.list.Check(i)

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        self.sizer.SetDimension(0,0,s[0],s[1])

 #    def on_send(self,evt):
#         txt = self.handler.get_selected_text()
#         if(txt != ""):
#             if txt[0] != "/": ## it's not a slash command
#                 action = self.chat.ParsePost(self.chat.colorize(self.chat.mytextcolor, txt),true,true)
#             else:
#                 action = self.chat.ParseDice(txt)
#                 self.chat.emote.docmd(txt)

    

BUT_ADD = wxNewId()
BUT_REM = wxNewId()
BUT_EDIT = wxNewId()
F_TYPE = wxNewId()
F_NO_TITLE = wxNewId()
    
class listbox_edit_panel(wxBoxedSizer):
    def __init__(self, parent, handler):
        wxBoxedSizer.__init__(self, parent, "List Box Properties")
        self.handler = handler
        sizer = wxBoxSizer(wxVERTICAL)
       	
        self.text = orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name'))
        
        opts = handler.get_options()
        self.listbox = wxListBox(self,F_LIST,choices=opts)
        opts = ['Drop Down', 'List Box', 'Radio Box', 'Check List']
        self.type_radios = wxRadioBox(self,F_TYPE,"List Type",choices=opts)
        self.type_radios.SetSelection(handler.get_type())
        
        self.send_button = wxCheckBox(self, F_SEND_BUTTON, " Send Button")
        self.send_button.SetValue(handler.has_send_button())
        
        self.hide_title = wxCheckBox(self, F_NO_TITLE, " Hide Title")
        self.hide_title.SetValue(handler.is_hide_title())
               
        but_sizer = wxBoxSizer(wxHORIZONTAL)
        but_sizer.Add(wxButton(self, BUT_ADD, "Add"), 1, wxEXPAND) 
        but_sizer.Add(10,10)
        but_sizer.Add(wxButton(self, BUT_EDIT, "Edit"), 1, wxEXPAND)
        but_sizer.Add(10,10)        
        but_sizer.Add(wxButton(self, BUT_REM, "Remove"), 1, wxEXPAND)
                      
        sizer.Add(wxStaticText(self, -1, "Title:"), 0, wxEXPAND)
        sizer.Add(self.text, 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(self.type_radios, 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(self.send_button, 0 , wxEXPAND)
        sizer.Add(self.hide_title, 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(wxStaticText(self, -1, "Options:"), 0, wxEXPAND)
        sizer.Add(self.listbox,1,wxEXPAND);
        sizer.Add(but_sizer,0,wxEXPAND)

        self.set_sizer(sizer)

        EVT_TEXT(self, P_TITLE, self.on_text)
        EVT_BUTTON(self, BUT_EDIT, self.on_edit)
        EVT_BUTTON(self, BUT_REM, self.on_remove)
        EVT_BUTTON(self, BUT_ADD, self.on_add)
        EVT_RADIOBOX(self, F_TYPE, self.on_type)
        EVT_CHECKBOX(self, F_NO_TITLE, self.on_hide_button)
        EVT_CHECKBOX(self, F_SEND_BUTTON, self.on_send_button)

    def on_type(self,evt):
        self.handler.set_type(evt.GetInt())

    def on_add(self,evt):
        dlg = wxTextEntryDialog(self, 'Enter option?','Add Option', '')
        if dlg.ShowModal() == wxID_OK:
            self.handler.add_option(dlg.GetValue())
        dlg.Destroy()
        self.reload_options()
        
    def on_remove(self,evt):
        index = self.listbox.GetSelection()
        if index >= 0:
            self.handler.remove_option(index)
            self.reload_options() 
    
    def on_edit(self,evt):
        index = self.listbox.GetSelection()
        if index >= 0:
            txt = self.handler.get_option(index)
            dlg = wxTextEntryDialog(self, 'Enter option?','Edit Option', txt)
            if dlg.ShowModal() == wxID_OK:
                self.handler.edit_option(index,dlg.GetValue())
            dlg.Destroy()
            self.reload_options() 

    def reload_options(self):
        self.listbox.Clear()
        for opt in self.handler.get_options():
            self.listbox.Append(opt)
    
    def on_text(self,evt):
        id = evt.GetId()
        txt = self.text.GetValue()
        if not len(txt): return        	
        if id == P_TITLE:
            self.handler.master_dom.setAttribute('name',txt)
            self.handler.rename(txt)
            
    def on_send_button(self,evt):
        self.handler.list.setAttribute("send_button",str(evt.Checked()))

    def on_hide_button(self,evt):
        self.handler.list.setAttribute("hide_title",str(evt.Checked()))
    
        
###############################
## link image handlers
###############################

class link_handler(node_handler):
    """ A nodehandler for URLs. Will open URL in a wxHTMLFrame
        <nodehandler name='?' module='forms' class='link_handler' >
                <link  href='http//??.??'  />
        </nodehandler >
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.link = self.master_dom._get_firstChild()        

    def on_use(self,evt):                
        href = self.link.getAttribute("href")
        wb = webbrowser.get() 
        wb.open(href) 

    def get_design_panel(self,parent): 
        return link_edit_panel(parent,self)

    def get_use_panel(self,parent): 
        return link_panel(parent,self)

    def tohtml(self):
        href = self.link.getAttribute("href")
        title = self.master_dom.getAttribute("name")
        return "<a href=\""+href+"\" >"+title+"</a>"
        
class link_panel(wxStaticText):
    def __init__(self,parent,handler):
        self.handler = handler        
        label = handler.master_dom.getAttribute('name') 
        wxStaticText.__init__(self,parent,-1,label)
        self.SetForegroundColour(wxBLUE)
        EVT_LEFT_DOWN(self,self.handler.on_use) 


P_URL = wxNewId()
        
class link_edit_panel(wxBoxedSizer):
    def __init__(self, parent, handler):
        wxBoxedSizer.__init__(self, parent, "Link Properties")
        self.handler = handler
        sizer = wxBoxSizer(wxVERTICAL)
       	
       	self.text = {}
        self.text[P_TITLE] = orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name'))
        self.text[P_URL] = orpgTextCtrl(self, P_URL, handler.link.getAttribute('href'))
        
        sizer.Add(wxStaticText(self, -1, "Title:"), 0, wxEXPAND)
        sizer.Add(self.text[P_TITLE], 0, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(wxStaticText(self, -1, "URL:"), 0, wxEXPAND)
        sizer.Add(self.text[P_URL], 0, wxEXPAND)
        self.set_sizer(sizer)
        EVT_TEXT(self, P_TITLE, self.on_text)
        EVT_TEXT(self, P_URL, self.on_text)

    def on_text(self,evt):
        id = evt.GetId()
        txt = self.text[id].GetValue()
        if not len(txt): return        	
        if id == P_TITLE:
            self.handler.master_dom.setAttribute('name',txt)
            self.handler.rename(txt) 
        elif id == P_URL:
            self.handler.link.setAttribute('href',txt)
            
##########################
## webimg node handler
##########################        
class webimg_handler(node_handler):
    """ A nodehandler for URLs. Will open URL in a wxHTMLFrame
        <nodehandler name='?' module='forms' class='webimg_handler' >
                <link  href='http//??.??'  />
        </nodehandler >
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.link = self.master_dom._get_firstChild() 
  
    def get_design_panel(self,parent): 
        return link_edit_panel(parent,self)
        
    def get_use_panel(self,parent): 
        img = img_helper().load_url(self.link.getAttribute("href"))
        #print img
        return wxStaticBitmap(parent,-1,img,size=wxSize(img.GetWidth(),img.GetHeight()))

    def tohtml(self):
        href = self.link.getAttribute("href")
        title = self.master_dom.getAttribute("name")
        return "<img src=\""+href+"\" alt="+title+" >" 
