// PEscript VM opcodes

enum {
	PEVM_Return,
	PEVM_CallVRM,
	PEVM_Printstr,
	PEVM_Printint,
	PEVM_PrintXint,
	PEVM_PrintCR,
	PEVM_ClearLine,
	PEVM_Callfunc,
	PEVM_CallfuncS,
	PEVM_Let_iei,
	PEVM_Let_ieipi,
	PEVM_Let_pes,
	PEVM_Add,
	PEVM_Goto,
	PEVM_If_iei,
	PEVM_If_oics,
	PEVM_If_oeo,
	PEVM_If_oEo,
	PEVM_If_ses,
	PEVM_If_o,
	PEVM_If_no,
	PEVM_For,
	PEVM_Searchin,
	PEVM_Listafter,
	PEVM_SearchWorld,
	PEVM_StopSearch,
	PEVM_PlayMusic,
	PEVM_StopMusic,
	PEVM_IsPlaying,
	PEVM_PlaySound,
	PEVM_ObjSound,
	PEVM_Create,
	PEVM_CreateS,
	PEVM_Destroy,
	PEVM_SetDarkness,
	PEVM_If_on,
	PEVM_If_non,
	PEVM_If_tn,
	PEVM_If_ntn,
	PEVM_SetFlag,
	PEVM_GetFlag,
	PEVM_SetPFlag,
	PEVM_GetPFlag,
	PEVM_SetUFlag,
	PEVM_GetUFlag,
	PEVM_SetLocal,
	PEVM_GetLocal,
	PEVM_ResetFlag,
	PEVM_MoveObject,
	PEVM_PushObject,
	PEVM_XferObject,
	PEVM_ShowObject,
	PEVM_GotoXY,
	PEVM_PrintXYi,
	PEVM_PrintXYs,
	PEVM_PrintXYx,
	PEVM_PrintXYcr,
	PEVM_TextColour,
	PEVM_TextFont,
	PEVM_SetSequenceN,
	PEVM_SetSequenceS,
	PEVM_Lightning,
	PEVM_Earthquake,
	PEVM_Bestname,
	PEVM_GetObject,
	PEVM_GetSolidObject,
	PEVM_GetFirstObject,
	PEVM_GetTile,
	PEVM_GetObjectBelow,
	PEVM_ChangeObject,
	PEVM_ChangeObjectS,
	PEVM_ReplaceObject,
	PEVM_ReplaceObjectS,
	PEVM_SetDir,
	PEVM_RedrawMap,
	PEVM_RedrawText,
	PEVM_MoveToPocket,
	PEVM_XferToPocket,
	PEVM_MoveFromPocket,
	PEVM_ForceFromPocket,
	PEVM_Spill,
	PEVM_SpillXY,
	PEVM_FadeOut,
	PEVM_FadeIn,
	PEVM_MoveToTop,
	PEVM_MoveToFloor,
	PEVM_GetLOS,
	PEVM_CheckHurt,
	PEVM_IfSolid,
	PEVM_IfVisible,
	PEVM_WeighObject,
	PEVM_GetBulk,
	PEVM_InputInt,
	PEVM_IfInPocket,
	PEVM_IfNInPocket,
	PEVM_ReSyncEverything,
	PEVM_ResumeSchedule,
	PEVM_TalkTo1,
	PEVM_TalkTo2,
	PEVM_Random,
	PEVM_GetYN,
	PEVM_GetYNN,
	PEVM_Restart,
	PEVM_ScrTileN,
	PEVM_ScrTileS,
	PEVM_While1,
	PEVM_While2,
	PEVM_Break,
	PEVM_GetKey,
	PEVM_GetKey_quiet,
	PEVM_DoAct,
	PEVM_DoActS,
	PEVM_DoActTo,
	PEVM_DoActSTo,
	PEVM_NextAct,
	PEVM_NextActS,
	PEVM_NextActTo,
	PEVM_NextActSTo,
	PEVM_InsAct,
	PEVM_InsActS,
	PEVM_InsActTo,
	PEVM_InsActSTo,
	PEVM_StopAct,
	PEVM_ResumeAct,
	PEVM_GetContainer,
	PEVM_SetLeader,
	PEVM_SetMember,
	PEVM_AddMember,
	PEVM_DelMember,
	PEVM_MoveTowards8,
	PEVM_MoveTowards4,
	PEVM_WaitForAnimation,
	PEVM_WaitFor,
	PEVM_If_oonscreen,
	PEVM_If_not_oonscreen,
	PEVM_GiveQty,
	PEVM_TakeQty,
	PEVM_MoveQty,
	PEVM_CountQty,
	PEVM_CopySchedule,
	PEVM_AllOnscreen,
	PEVM_AllAround,
	PEVM_CheckTime,
	PEVM_FindNear,
	PEVM_FindNearby,
	PEVM_FindTag,
	PEVM_FastTag,
	PEVM_MakeTagList,
	PEVM_SetLight,
	PEVM_SetLight_single,
	PEVM_MoveTag,
	PEVM_UpdateTag,
	PEVM_GetDataSSS,
	PEVM_GetDataSSI,
	PEVM_GetDataSIS,
	PEVM_GetDataSII,
	PEVM_GetDataISS,
	PEVM_GetDataISI,
	PEVM_GetDataIIS,
	PEVM_GetDataIII,
	PEVM_GetDecor,
	PEVM_DelDecor,
	PEVM_SearchContainer,
	PEVM_ChangeMap1,
	PEVM_ChangeMap2,
	PEVM_PicScroll,
	PEVM_SetPanel,
	PEVM_FindPathMarker,
	PEVM_ReSolid,
	PEVM_SetPName,
	PEVM_DelProp,
	PEVM_QUpdate,

	PEVM_AddRange,
	PEVM_GridRange,
	PEVM_AddButton,
	PEVM_PushButton,
	PEVM_RightClick,
	PEVM_FlushMouse,
	PEVM_RangePointer,
	PEVM_MovePartyToObj,
	PEVM_MovePartyFromObj,
	PEVM_SaveScreen,
	PEVM_RestoreScreen,
	PEVM_fxGetXY,
	PEVM_fxColour,
	PEVM_fxAlpha,
	PEVM_fxAlphaMode,
	PEVM_fxRandom,
	PEVM_fxLine,
	PEVM_fxPoint,
	PEVM_fxRect,
	PEVM_fxPoly,
	PEVM_fxOrbit,
	PEVM_fxSprite,
	PEVM_fxCorona,
	PEVM_fxAnimSprite,
	PEVM_dofx,
	PEVM_dofxS,
	PEVM_dofxOver,
	PEVM_dofxOverS,
	PEVM_stopfx,

	PEVM_Printaddr,
	PEVM_PrintLog,
	PEVM_LastOp,
	// Internal functions
	PEVM_GetFuncP=0xfc,
	PEVM_Dump=0xfd,
	PEVM_NOP=0xfe,
	PEVM_Dofus=0xff
	};

#define IS_ON           0x00000001
#define CAN_OPEN        0x00000002
#define IS_OVERLAY      0x00000004
#define IS_SOLID        0x00000008
#define IS_FRAGILE      0x00000010
#define IS_TRIGGER      0x00000020
#define IS_INVISIBLE    0x00000040
#define IS_WIELDED      0x00000040
#define IS_PARTY        0x00000080
#define IS_FIXED        0x00000100
#define IS_CONTAINER    0x00000200
#define IS_TRANSLUCENT  0x00000400
#define IS_LARGE        0x00000800
#define IS_SPIKEPROOF   0x00001000
#define CAN_WIELD       0x00002000
#define DID_STEPUPDATE  0x00004000
//#define IS_RANGED       0x00008000
#define DOES_BLOCKLIGHT 0x00010000
#define IS_TABLETOP     0x00020000
#define DID_INIT        0x00040000
#define DID_UPDATE      0x00080000
#define IS_PERSON       0x00100000
#define IS_HORRIBLE     0x00200000
#define IS_HORROR       0x00200000
#define IS_SHOCKING     0x00200000
#define IS_QUANTITY     0x00400000
#define IS_BOAT         0x00800000
#define IS_WATER        0x00800000
#define IS_SHADOW       0x01000000
#define IS_DECOR        0x02000000
#define IS_SYSTEM       0x04000000

#define IS_FEMALE       0x80000001
#define KNOW_NAME       0x80000002
#define IS_HERO         0x80000004
#define CANT_EAT        0x80000008
#define CANT_DRINK      0x80000008      // Synonymous with CANT_EAT
#define IS_CRITICAL     0x80000010
#define NOT_CLOSE_DOOR  0x80000020
#define NOT_CLOSE_DOORS 0x80000020
#define IS_SYMLINK      0x80000040
#define IS_BIOLOGICAL   0x80000080
#define IS_GUARD        0x80000100
#define IS_SPAWNED      0x80000200
#define NOT_OPEN_DOOR   0x80000400
#define NOT_OPEN_DOORS  0x80000400
#define IN_BED          0x80000800
#define IS_LEADER       0x80000800

#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3

#define CHAR_U 0
#define CHAR_D 1
#define CHAR_L 2
#define CHAR_R 3

#define ALPHA_SOLID       0
#define ALPHA_TRANS       1
#define ALPHA_ADD         2
#define ALPHA_BURN        3
#define ALPHA_COLOR       4
#define ALPHA_COLOUR      4
#define ALPHA_DIFFERENCE  5
#define ALPHA_DISSOLVE    6
#define ALPHA_DODGE       7
#define ALPHA_HUE         8
#define ALPHA_INVERT      9
#define ALPHA_LUMINANCE   10
#define ALPHA_MULTIPLY    11
#define ALPHA_SATURATION  12
#define ALPHA_SCREEN      13

// Tint bitmasks
#define TINT_RED 1
#define TINT_GREEN 2
#define TINT_BLUE 4
#define TINT_YELLOW 3
#define TINT_PURPLE 5
#define TINT_MAGENTA 5
#define TINT_CYAN 6
#define TINT_LIGHTBLUE 6
#define TINT_WHITE 7

extern int pe_result_ok;
