/*
 *  - Sequence editor menu tab
 */


#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"

#ifndef _WIN32
#include <unistd.h>
#endif

// defines

#define VIEWX 32
#define VIEWY 160
#define STR_LEN 32
#define OVL_LEN 24

// variables

extern int focus,SQ_Id;

static int curseq=0,curframe=0;
static int SeqName_Id;
static int Loop_Id,Ping_Id,Step_Id,X_Id,Y_Id,Speed_Id,Overlay_Id,JumpTo_Id,Frame_Id,Rand_Id;
static char Xoffstr[]="0   ";
static char Yoffstr[]="0   ";
static char Speedstr[]="0  ";
static char Overlaystr[25];
static char JumpTostr[25];
static char SeqName[33];
static char FrameStr[]="  0/0  ";
static char str32[STR_LEN+1];
static int doesloop=0,doespp=0,doesstep=0,doesrand=0;

// functions

extern void Toolbar();

static void Nothing();
static void SeqUpdate();                       // Update the displays
static void ToggleLoop();
static void TogglePP();
static void ToggleStep();
static void ToggleRand();
static void NextFrame();
static void PrevFrame();
static void GetFrame();
static void AddFrame();
static void DelFrame();
static void SetFrame();
static void PickSequence();
static void AddSequence();
static void DelSequence();
static void SequenceName();
static void Xoffset();
static void Yoffset();
static void Overlay();
static void JumpTo();
static void Speed();
static S_POOL *PickSprite(char *iname);
static int SequenceInUseByChar(int seq);
static int SequenceInUseBySeq(int seq);

// GoFocal - The menu tab function.  This is called from the toolbar

void SQ_GoFocal()
{
if(focus==2)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;
memset(Overlaystr,' ',OVL_LEN); Overlaystr[OVL_LEN]=0;
memset(JumpTostr,' ',OVL_LEN); JumpTostr[OVL_LEN]=0;
memset(SeqName,' ',STR_LEN); SeqName[STR_LEN]=0;

focus=2;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(SQ_Id);     // And make the button stick inwards

IG_TextButton(320,140,"Add frame",AddFrame,NULL,NULL);
IG_TextButton(416,140,"Edit frame",SetFrame,NULL,NULL);
IG_TextButton(520,140,"Del frame",DelFrame,NULL,NULL);

DrawScreenText(320,212,"Animation repeats");
Loop_Id = IG_ToggleButton(524,204,"   ",ToggleLoop,NULL,NULL,&doesloop);
IG_SetInText(Loop_Id," X ");
DrawScreenText(320,244,"Animation Ping-pongs");
Ping_Id = IG_ToggleButton(524,236,"   ",TogglePP,NULL,NULL,&doespp);
IG_SetInText(Ping_Id," X ");
DrawScreenText(320,276,"Only update when moving");
Step_Id = IG_ToggleButton(524,268,"   ",ToggleStep,NULL,NULL,&doesstep);
IG_SetInText(Step_Id," X ");
DrawScreenText(320,308,"Random animation");
Rand_Id = IG_ToggleButton(524,300,"   ",ToggleRand,NULL,NULL,&doesrand);
IG_SetInText(Rand_Id," X ");

DrawScreenText(320,340,"X hotspot");
X_Id = IG_InputButton(396,332,Xoffstr,Xoffset,NULL,NULL);
DrawScreenText(448,340,"Y hotspot");
Y_Id = IG_InputButton(524,332,Yoffstr,Yoffset,NULL,NULL);

DrawScreenText(320,372,"Speed ");
Speed_Id = IG_InputButton(380,364,Speedstr,Speed,NULL,NULL);
DrawScreenText(320,404,"Overlay spr");
Overlay_Id = IG_InputButton(412,396,Overlaystr,Overlay,NULL,NULL);
DrawScreenText(320,436,"Link to seq");
JumpTo_Id = IG_InputButton(412,428,JumpTostr,JumpTo,NULL,NULL);

// Sprite list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

IG_TextButton(32,429,"Prev Frame",PrevFrame,NULL,NULL);
Frame_Id = IG_InputButton(128,429,FrameStr,GetFrame,NULL,NULL);
IG_TextButton(200,429,"Next Frame",NextFrame,NULL,NULL);

// Set frame to a sprite
IG_Region(VIEWX,VIEWY,256,256,SetFrame,NULL,NULL);

IG_TextButton(32,64," Add new animation ",AddSequence,NULL,NULL);
IG_AddKey(KEY_A,AddSequence);

IG_TextButton(32,96," Pick an animation ",PickSequence,NULL,NULL);
IG_AddKey(KEY_P,PickSequence);

IG_TextButton(32,128," Delete animation  ",DelSequence,NULL,NULL);
IG_AddKey(KEY_D,DelSequence);

DrawScreenText(224,104,"Animation:");
SeqName_Id = IG_InputButton(320,96,str32,SequenceName,NULL,NULL);

SeqUpdate();
}

void AddSequence()
{
for(long ctr=0;ctr<seq_alloc;ctr++)
    if(!SQlist[ctr].name)
        {
        SQlist[ctr].name=(char *)M_get(1,32);
        curseq=ctr;
        sprintf(SQlist[ctr].name,"SEQUENCE_%d",ctr);
        SQlist[ctr].frames=1;
        SQlist[ctr].speed=0;
        SQlist[ctr].flags=0;
        SQlist[ctr].x=0;
        SQlist[ctr].y=0;
        SQlist[ctr].overlay=NULL;
        SQlist[ctr].jumpto=NULL;
        SQlist[ctr].seq = (S_POOL **)M_get(sizeof(S_POOL *),SQlist[ctr].frames+1);
        SQlist[ctr].seq[0]=&SPlist[0];
        SeqUpdate();
        SequenceName();
        return;
        }
Notify(-1,-1,"Cannot create a new sequence.","Increase the value of MAX_SEQUENCES in SCRIPTER.INI");
}

void PickSequence()
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(seq_alloc,sizeof(char *));

for(ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name)
         mlist[num++]=SQlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,SQlist[curseq].name);
InputNameFromListWithFunc(-1,-1,"Choose an animation sequence:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,SQlist[curseq].name);

M_free(mlist);

for(ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name != NULL)
    if(!stricmp(SQlist[ctr].name,name))
        {
        curseq=ctr;
        SeqUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void DelSequence()
{
int res;
char msg[80];

if(curseq == 0)
    {
    Notify(-1,-1,"This sequence is special and cannot be deleted.","You can still change it to something else though..");
    return;
    }

res=SequenceInUseByChar(curseq);
if(res != -1)
    {
    sprintf(msg,"This sequence is used by character '%s'",CHlist[res].name);
    Notify(-1,-1,msg,"Please modify the character first");
    return;
    }
res=SequenceInUseBySeq(curseq);
if(res != -1)
    {
    sprintf(msg,"This sequence is linked to by sequence '%s'",SQlist[res].name);
    Notify(-1,-1,msg,"Please modify the other sequence first");
    return;
    }

if(Confirm(-1,-1,"Really delete this animation sequence?",SQlist[curseq].name))
    {
    M_free(SQlist[curseq].name);
    SQlist[curseq].name = NULL;
    curseq=0;
    SeqUpdate();
    }
}

SEQ_POOL *GetSequence(char *original)
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(seq_alloc,sizeof(char *));
mlist[num++]="-";

for(ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name)
         mlist[num++]=SQlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,original);
InputNameFromListWithFunc(-1,-1,"Choose an animation:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,original);

M_free(mlist);

for(ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name != NULL)
    if(!stricmp(SQlist[ctr].name,name))
        return &SQlist[ctr];

return NULL;         // This is NONE
}


S_POOL *PickSprite(char *iname)
{
char name[128];
char **mlist;
long num=0,ctr;

mlist = (char **)M_get(spr_alloc+1,sizeof(char *));

mlist[num++]="-";   // This is for NONE

for(ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name)
        mlist[num++]=SPlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,iname);
InputNameFromListWithFunc(-1,-1,"Choose a sprite:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,iname);

M_free(mlist);

for(ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name != NULL)
    if(!stricmp(SPlist[ctr].name,name))
        return &SPlist[ctr];

return NULL;
}


// Callback for a null event

void Nothing()
{
return;
}

void PrevFrame()
{
curframe--;
//usleep(50000);
rest(50);
SeqUpdate();
}

// Callback for Next Sprite

void NextFrame()
{
curframe++;
//usleep(50000);
rest(50);
/*
if(curframe>=SQlist[curseq].frames)
   Notify(-1,-1,"Creating new sprite",NULL);
   SPedit[curspr].fname = M_get(1,64);
   SPedit[curspr].name = M_get(1,64);
   strcpy(SPedit[curspr].fname,"none");
   strcpy(SPedit[curspr].name,"none");
   }
*/
SeqUpdate();
}

void GetFrame()
{
curframe = InputIntegerValue(-1,-1,1,SQlist[curseq].frames,curframe+1)-1;
SeqUpdate();
}

void AddFrame()
{
SQlist[curseq].frames++;
SQlist[curseq].seq = (S_POOL **)realloc(SQlist[curseq].seq,sizeof(S_POOL *)*(SQlist[curseq].frames+1));
SQlist[curseq].seq[SQlist[curseq].frames-1]=SQlist[curseq].seq[SQlist[curseq].frames-2];
IG_WaitForRelease();
SeqUpdate();
}

void DelFrame()
{
if(SQlist[curseq].frames<2)
    return;
SQlist[curseq].frames--;
SQlist[curseq].seq = (S_POOL **)realloc(SQlist[curseq].seq,sizeof(S_POOL *)*(SQlist[curseq].frames+1));
IG_WaitForRelease();
SeqUpdate();
}

void SetFrame()
{
S_POOL *i;
i = PickSprite(SQlist[curseq].seq[curframe]->name);
if(i)
    SQlist[curseq].seq[curframe] = i;
SeqUpdate();
}

// Function for updating the display

void SeqUpdate()
{
int num=0,ctr;
// Update the sprite number

// Clear the sprite's name and path, set to proper value later, if valid no.
//IG_UpdateText(SeqPath_Id,"");
//IG_UpdateText(SeqName_Id,"");

strcpy(SeqName,str32);
if(!SQlist[curseq].name>=SQtot)
    num = -1;
else
    {
    strcpy(SeqName,SQlist[curseq].name);

    //    num = GetNumForFilename(SQlist[curseq].fname);
//    IG_UpdateText(SeqPath_Id,SQlist[curseq].fname);
//    IG_UpdateText(SeqName_Id,SQlist[curseq].name);

    if(SQlist[curseq].flags & 16)       // If it's random, then
        SQlist[curseq].flags&=0xfc;     // strip off PP and LOOP

    doespp = SQlist[curseq].flags & 1;
    doesloop = SQlist[curseq].flags & 2;
    doesstep = SQlist[curseq].flags & 4;
    doesrand = SQlist[curseq].flags & 16;

    draw_button(Ping_Id);
    draw_button(Loop_Id);
    draw_button(Step_Id);
    draw_button(Rand_Id);

    strcpy(Overlaystr,"-");
    if(SQlist[curseq].overlay)
        if(SQlist[curseq].overlay->name)
            strcpy(Overlaystr,SQlist[curseq].overlay->name);

    // Pad out with spaces
    for(ctr=strlen(Overlaystr);ctr<OVL_LEN;ctr++)
        Overlaystr[ctr]=' ';
    Overlaystr[OVL_LEN]=0;

    IG_UpdateText(Overlay_Id,Overlaystr);

    strcpy(JumpTostr,"-");
    if(SQlist[curseq].jumpto)
        if(SQlist[curseq].jumpto->name)
            strcpy(JumpTostr,SQlist[curseq].jumpto->name);

    // Pad out with spaces
    for(ctr=strlen(JumpTostr);ctr<OVL_LEN;ctr++)
        JumpTostr[ctr]=' ';
    JumpTostr[OVL_LEN]=0;

    IG_UpdateText(JumpTo_Id,JumpTostr);

    fbox2(0,0,256,256,ITG_BLUE,gamewin);
    if(curframe<0)
        curframe=0;
    if(curframe>=SQlist[curseq].frames)
        curframe=SQlist[curseq].frames-1;
//    SQlist[curseq].seq[curframe]->image.cel_put_sprite(0,0,bg_screen);
	draw_rle_sprite(gamewin,SQlist[curseq].seq[curframe]->image,0,0);

	if(SQlist[curseq].x>0 || SQlist[curseq].y>0)
		rect(gamewin,SQlist[curseq].x<<5,SQlist[curseq].y<<5,(SQlist[curseq].x<<5)+32,(SQlist[curseq].y<<5)+32,ITG_WHITE);

    sprintf(FrameStr,"%3d/%3d",curframe+1,SQlist[curseq].frames);
    IG_UpdateText(Frame_Id,FrameStr);
    }

//IG_UpdateText(SeqName_Id,SeqName);
IG_UpdateText(SeqName_Id,SeqName);

if(num==-1)
    {
    fbox2(VIEWX,VIEWY,256,256,ITG_BLUE,swapscreen);
    DrawScreenText(VIEWX+8,VIEWY+8,"Does not exist");
    return;
    }

// Draw it

draw_sprite(swapscreen,gamewin,VIEWX,VIEWY);
//transfer.get_sprite(0,0,bg_screen);
//transfer.block_put_sprite(VIEWX,VIEWY,swapscreen);

}

void TogglePP()
{
SQlist[curseq].flags &= 0xfe;
if(SQlist[curseq].flags & 16)   // Random animations can't pingpong
    {
    doespp=0;
    return;
    }
if(doespp)
    SQlist[curseq].flags |= 1;
IG_WaitForRelease();
SeqUpdate();
}

void ToggleLoop()
{
SQlist[curseq].flags &= 0xfd;
if(SQlist[curseq].flags & 16)   // Random animations can't loop
    {
    doesloop=0;
    return;
    }
if(doesloop)
    SQlist[curseq].flags |= 2;
IG_WaitForRelease();
SeqUpdate();
}

void ToggleStep()
{
SQlist[curseq].flags &= 0xfb;
if(doesstep)
    SQlist[curseq].flags |= 4;
IG_WaitForRelease();
SeqUpdate();
}

void ToggleRand()
{
SQlist[curseq].flags &= 0xef;
if(doesrand)
    SQlist[curseq].flags |= 16;
IG_WaitForRelease();
SeqUpdate();
}

void Xoffset()
{
SQlist[curseq].x = InputIntegerValue(-1,-1,-128,127,SQlist[curseq].x);
itoa(SQlist[curseq].x,Xoffstr,10);
SeqUpdate();
}

void Yoffset()
{
SQlist[curseq].y = InputIntegerValue(-1,-1,-128,127,SQlist[curseq].y);
itoa(SQlist[curseq].y,Yoffstr,10);
SeqUpdate();
}

void Overlay()
{
char vname[128];

if(SQlist[curseq].overlay)
    strcpy(vname,SQlist[curseq].overlay->name);
else
    strcpy(vname,"-");
//    strcpy(vname,SPlist[0].name);

SQlist[curseq].overlay = PickSprite(vname);
SeqUpdate();
}

void JumpTo()
{
char vname[128];

if(SQlist[curseq].jumpto)
    strcpy(vname,SQlist[curseq].jumpto->name);
else
//    strcpy(vname,SQlist[0].name);
    strcpy(vname,"-");

SQlist[curseq].jumpto = GetSequence(vname);
SeqUpdate();
}

void Speed()
{
SQlist[curseq].speed = InputIntegerValue(-1,-1,0,255,SQlist[curseq].speed);
itoa(SQlist[curseq].speed,Speedstr,10);
SeqUpdate();
}

void SequenceName()
{
InputString(-1,-1,"Enter the new description of the animation",32,SQlist[curseq].name);
SeqUpdate();
}

int SequenceInUseByChar(int seq)
{
int ctr;

for(ctr=0;ctr<chr_alloc;ctr++)
   {
   if(CHlist[ctr].name)
      {
      if(CHlist[ctr].dir[CHAR_U] == seq)
          return ctr;
      if(CHlist[ctr].dir[CHAR_D] == seq)
          return ctr;
      if(CHlist[ctr].dir[CHAR_L] == seq)
          return ctr;
      if(CHlist[ctr].dir[CHAR_R] == seq)
          return ctr;
      }
   }

return -1;
}

int SequenceInUseBySeq(int seq)
{
int ctr;

for(ctr=0;ctr<seq_alloc;ctr++)
   {
   if(SQlist[ctr].name)
      if(SQlist[ctr].jumpto == &SQlist[seq])
          return ctr;
   }

return -1;
}
