/*
        IRE resource editor

Copyright (c) 2001, IT-HE Software
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

Neither the name of IT-HE Software nor the names of its contributors may
be used to endorse or promote products derived from this software without
specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/


#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef __DJGPP__
#include <conio.h>
#include <dos.h>
#endif

#ifndef _WIN32
#include <unistd.h>
#endif

#include <string.h>
#include <stdarg.h>

#include "../core.hpp"     // Main data structures
#include "../ithelib.h"    // Support lib
#include "../media.h"      // Graphics etc
#include "../init.h"     // Init module
#include "../linklist.hpp" // Linked list alloc and free routines
#include "../oscli.h"      // Operating system command line interpreter
#include "../console.h"    // Text output and logger routines
#include "../cookies.h"    // Signatures for the Z1/Z2 map files
#include "../script.hpp"   // The script file loader and search routines
#include "../loadsave.hpp" // Map IO routines
#include "../loadfile.h" 	// Find correct file to open
#include "../sound.h"    // Include the SMTab data structure
#include "../gamedata.h" // Shared data
#include "grok.h" 		// File scanner

#include "../gui/igui.hpp"

// Defines

// Variables

/*
FILES imagefiles;
FILES vrmfiles;
FILES Wavfiles;
FILES Modfiles;
*/

extern "C" int Waves,Songs;

int AB_Id,SP_Id,WA_Id,MO_Id,CO_Id,SQ_Id,CH_Id,TI_Id,RT_Id,LT_Id;

char **sprites;
char **vrmfuncs;
char **wavfiles;
char **musfiles;
extern char **pe_files;
int spr_total,seq_total,vrm_total,wav_total,mus_total,til_total,rft_total=256,lgt_total=256;
int focus=666;

SMTab *mustab,*wavtab;  // More dummies

char __up[]="^";     // The arrow icons (lame, no?)
char __down[]="v";
char __left[]={"<"};
char __left2[]={"<<"};
char __right[]={">"};
char __right2[]={">>"};

BITMAP *gamewin;
RGB pal[256];
static char projectdir[1024];
char imgcachedir[1024];

// Functions

void banner();

void Toolbar();

void Quit();
void Snap();

void S_load();
void S_save();

extern void AB_GoFocal();       // About box handle
extern void SP_GoFocal();       // Sprites handle
extern void SQ_GoFocal();       // Animation Sequences handle
extern void CH_GoFocal();       // Characters handle
extern void WA_GoFocal();       // Wavfile handle
extern void MO_GoFocal();       // Modfile handle
extern void CO_GoFocal();       // VRM handle
extern void TI_GoFocal();       // Tiles
extern void RT_GoFocal();       // Roof Tiles
extern void LT_GoFocal();       // Lightmaps
extern void LoadResources(char *filename);

static void Write(FILE *fp,char *msg, ...);
static void tabs(char *tabbuf,char *msg);

// Code

/*
 *      Main - start up all the things, run them, stop all the things, exit
 */

int main(int argc, char *argv[])
{
int ctr;
char fname[1024];
char *vrmlist[]={"*.vrm",NULL};
char *wavlist[]={"*.wav",NULL};
char *muslist[]={"*.aud",NULL};
char *imglist[]={"*.cel","*.pcx",NULL};
GROKFILES Vrmfiles,Wavfiles,Musfiles,imagefiles;

allegro_init();		// We need this ASAP

in_editor = 2;    // Some init functions are not necessary for the editor

#ifdef FORTIFY
remove("fortify.out");
#endif

strcpy(projectname,"flat"); // Set to sensible default

M_init();         // Init memory systems

strcpy(newbootlog,"bootlog.txt"); // This could be changed later in OSCLI
strcpy(oldbootlog,"bootlog.prv"); // If I get round to it..

// Get defaults

if(argc>=2)
    OSCLI(argc,argv);       // input from OSCLI

INI_file("resedit.ini");     // Read the ini file and act upon it

if(!projectname[0])
	ithe_safepanic("No project was specified.","There should be a -project <projectname> line in one of the INI files.");

// Project directory
strcpy(projectdir,projectname);
strcat(projectdir,"/");
ifile_prefix=&projectdir[0];

ilog_start(newbootlog,oldbootlog);

ilog_printf("IRE Resource Editor, Copyright (C) 2000 IT-HE Software\n");
ilog_printf("======================================================\n");
ilog_printf("\n");
ilog_printf("IRE Kernel version %s\n",IKV);
ilog_printf("\n");
#ifndef _WIN32
sleep(1);
#endif

party = (OBJECT **)M_get(MAX_MEMBERS,sizeof(OBJECT *));
partyname = (char **)M_get(MAX_MEMBERS,sizeof(char *));

//ilog_printf("Init filesystem\n");

//RFS_Init(resdir);

init_media(0); // Enter graphics mode, not for game

// Work out the name of the image cache directory
#ifdef _WIN32
	sprintf(imgcachedir,"%s\\%s.%d\\",".",projectname,ire_bpp);
#else
	sprintf(imgcachedir,"%s/%s.%d/",".",projectname,ire_bpp);
#endif

gamewin = create_bitmap(256,256);
if(!gamewin)
      ithe_panic("Could not create game window",NULL);

ilog_printf("Console started\n");

if(!fileexists("resource.txt"))
	ithe_panic("Resource file not found..","Run Quickstart or choose another game directory");

ilog_printf("Gather resources...\n");

ilog_printf("  VRMs\n");
grok_files(&Vrmfiles,vrmlist);
vrmfuncs=Vrmfiles.list;
vrm_total=Vrmfiles.total;

ilog_printf("  Sounds\n");
grok_files(&Wavfiles,wavlist);
wavfiles=Wavfiles.list;
wav_total=Wavfiles.total;

ilog_printf("  Music\n");
grok_files(&Musfiles,muslist);
musfiles=Musfiles.list;
mus_total=Musfiles.total;

ilog_printf("  Images\n");
grok_files(&imagefiles,imglist);
sprites=imagefiles.list;
spr_total=imagefiles.total;

ilog_printf("Load Resources\n");
LoadResources("resource.txt");
ilog_printf("Making strings dynamic..\n");
Restring();
Init_Funcs();

for(ctr=0;ctr<MAX_MEMBERS;ctr++)
	partyname[ctr] = (char *)M_get(1,128);	// needed for other modules
ilog_printf("Go..\n");

irecon_term();	// Don't want the console anymore, it will mess the display

ilog_break=0; // Don't want to break now we're ready

// Editor routines start here

IG_Init(128);                   // Set up the iGUI for max 128 buttons

Toolbar();                      // Draw the menu bar at the top
                                // And then start the iGUI event loop

show_mouse(NULL);	// MOUSE HACK
AB_GoFocal();                   // Start on the ABOUT screen
show_mouse(swapscreen);	// MOUSE HACK

do IG_Dispatch(); while(running);       // Loop until quit

if(Confirm(-1,-1,"Do you want to save changes?",NULL))
	S_save();

IG_Term();                      // Free the iGUI resources

printf("Thankyou for using the Resource editor.\n");

return 0;			// Return a value to keep compiler happy
}
END_OF_MAIN();

/*
 *      Toolbar - set up the GUI components that are present in all cases
 */

void Toolbar()
{
IG_KillAll();
IG_AddKey(KEY_ESC,Quit);           // Add key binding for ESC = Quit
IG_AddKey(KEY_F10,Snap);           // Add key binding for shift-F10
IG_Panel(0,0,640,32);

IG_Panel(0,32,640,480-32);
AB_Id = IG_Tab(540,4,"About",AB_GoFocal,NULL,NULL);
SP_Id = IG_Tab(4,4,"Sprites",SP_GoFocal,NULL,NULL);
SQ_Id = IG_Tab(72,4,"Sequences",SQ_GoFocal,NULL,NULL);
CH_Id = IG_Tab(156,4,"Characters",CH_GoFocal,NULL,NULL);
CO_Id = IG_Tab(248,4,"Code",NULL,NULL,NULL);
//CO_Id = IG_Tab(248,4,"Code",CO_GoFocal,NULL,NULL);
WA_Id = IG_Tab(292,4,"Sound",WA_GoFocal,NULL,NULL);
MO_Id = IG_Tab(344,4,"Music",MO_GoFocal,NULL,NULL);
TI_Id = IG_Tab(396,4,"Tiles",TI_GoFocal,NULL,NULL);
RT_Id = IG_Tab(448,4,"Roof",RT_GoFocal,NULL,NULL);
LT_Id = IG_Tab(496,4,"Light",LT_GoFocal,NULL,NULL);
/*
WA_Id = IG_Tab(72,4,"Sound",WA_GoFocal,NULL,NULL);
MO_Id = IG_Tab(124,4,"Music",MO_GoFocal,NULL,NULL);
*/
IG_TextButton(594,4,"Quit",Quit,NULL,NULL);

// Hotkeys for the sections

IG_AddKey(KEY_1,SP_GoFocal);
IG_AddKey(KEY_2,SQ_GoFocal);
IG_AddKey(KEY_3,CH_GoFocal);
//IG_AddKey(KEY_4,CO_GoFocal);
IG_AddKey(KEY_5,WA_GoFocal);
IG_AddKey(KEY_6,MO_GoFocal);
IG_AddKey(KEY_7,TI_GoFocal);
IG_AddKey(KEY_8,RT_GoFocal);
IG_AddKey(KEY_9,LT_GoFocal);
IG_AddKey(KEY_0,AB_GoFocal);
}

/*
 *      Quit - The callback handler for Quitting
 */

void Quit()
{
if(Confirm(-1,-1,"Are you sure you want to quit?",NULL))
  running = 0;
}

/*
 *      Snap - The callback handler for taking a screen dump
 */

void Snap()
{
BMPshot();
}


/* ================================ Map RW =============================== */


void S_load()
{
/*
int ctr;

// First, copy the compiled SPlist to SPedit, for editing.
// Keep SPlist around as we will need it to get to the sprites later

SPedit=M_get(spr_alloc,sizeof(S_POOL));
for(ctr=0;ctr<SPtot;ctr++)
        {
        SPedit[ctr].fname = M_get(1,64);
        SPedit[ctr].name = M_get(1,64);
        strcpy(SPedit[ctr].fname,SPlist[ctr].fname);
        strcpy(SPedit[ctr].name,SPlist[ctr].name);
//        M_free(SPlist[ctr].fname);
//        M_free(SPlist[ctr].name);
        }

//M_free(SPlist);
*/

/*
SPlist=M_get(spr_total,sizeof(S_POOL));
for(ctr=0;ctr<spr_total;ctr++)
        {
        // Set up the master sprite list, just a table of Name against Image
        SPlist[ctr].fname = sprites[ctr];
        SPlist[ctr].name="Oh bugger!";
        Init_Sprite(ctr);
        }
//SPtot=spr_total;
*/
}

void S_save()
{
int ctr,ctr2,c;
FILE *fp;
//GOAL *g;
char str[21];
char path1[256];
char path2[256];


strcpy(path1,projectname);
strcat(path1,"/resource.bak");
strcpy(path2,projectname);
strcat(path2,"/resource.txt");
remove(path1);
rename(path2,path1);

fp=fopen(path2,"w");
if(!fp)
    ithe_panic("DAMN: Could not open output file:",path2);

// Descriptions
// Code
// Sprites
// Sequences
// Characters
// Tiles
// Sound
// Music
// RoofTiles
// Lightmaps

Write(fp,"#\n");
Write(fp,"# IRE resource file made by RESEDIT using game kernel %s\n",IKV);
Write(fp,"#\n\n");

// Write Sprites

if(SPtot>0)
    {
    Write(fp,"section: sprites\n\n");
    for(ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name && SPlist[ctr].fname)
        {
        tabs(str,SPlist[ctr].name);
        Write(fp,"\t%s%s%s\n",SPlist[ctr].name,str,SPlist[ctr].fname);
        }
    Write(fp,"\n\n");
    }

// Write Sequences

if(SQtot>0)
	{
	Write(fp,"section: sequences\n\n");
	for(ctr=0;ctr<seq_alloc;ctr++)
		if(SQlist[ctr].name)
			if(!SQlist[ctr].flags && !SQlist[ctr].x && !SQlist[ctr].y
			&& !SQlist[ctr].speed && !SQlist[ctr].overlay && SQlist[ctr].frames<2
			&& SQlist[ctr].translucency != 128)
				{
				Write(fp,"\tquickname %s %s\n",SQlist[ctr].name,SQlist[ctr].seq[0]->name);
				}
			else
				{
				Write(fp,"\n");
				Write(fp,"\tname %s\n",SQlist[ctr].name);

				if(SQlist[ctr].flags&SEQFLAG_PINGPONG)
					Write(fp,"\tpingpong\n");
				if(SQlist[ctr].flags&SEQFLAG_LOOP)
					Write(fp,"\tloop\n");
				if(SQlist[ctr].flags&SEQFLAG_STEPPED)
					Write(fp,"\tstepped\n");
				// 8 is used later
				if(SQlist[ctr].flags&SEQFLAG_RANDOM)
					Write(fp,"\trandom\n");
				if(SQlist[ctr].flags&SEQFLAG_CHIMNEY)
					Write(fp,"\tchimney\n");
				if(SQlist[ctr].flags&SEQFLAG_POSTOVERLAY)
					Write(fp,"\tpost_overlay\n");
				if(SQlist[ctr].flags&SEQFLAG_WALL)
					Write(fp,"\twall\n");

				if(SQlist[ctr].x)
					Write(fp,"\tx %d\n",SQlist[ctr].x);
				if(SQlist[ctr].y)
					Write(fp,"\ty %d\n",SQlist[ctr].y);
				if(SQlist[ctr].speed)
					Write(fp,"\tspeed %d\n",SQlist[ctr].speed);
				if(SQlist[ctr].overlay)
					Write(fp,"\toverlay %s\n",SQlist[ctr].overlay->name);
				if(SQlist[ctr].flags&SEQFLAG_JUMPTO)
					Write(fp,"\tjump_to %s\n",SQlist[ctr].jumpto->name);
				if(SQlist[ctr].translucency != 128) // 128 is default
					Write(fp,"\ttranslucency %d\n",SQlist[ctr].translucency);

				Write(fp,"\tframelist:\n");
				Write(fp,"\t#%d frames\n",SQlist[ctr].frames);
				for(ctr2=0;ctr2<SQlist[ctr].frames;ctr2++)
					Write(fp,"\t\t%s\n",SQlist[ctr].seq[ctr2]->name);
				Write(fp,"\tend\n");
				}

	Write(fp,"\n");
	Write(fp,"\n");
	}

// Write Characters (complex)

if(SQtot>0)
	{
	Write(fp,"section: characters\n\n");
	for(ctr=0;ctr<chr_alloc;ctr++)
		if(CHlist[ctr].name)
			{
			Write(fp,"\tname %s\n",CHlist[ctr].name);
			Write(fp,"\tleft\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_L]].name);
			Write(fp,"\tright\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_R]].name);
			Write(fp,"\tup\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_U]].name);
			Write(fp,"\tdown\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_D]].name);

			Write(fp,"\thp\t\t%d\n",CHlist[ctr].stats->hp);

			if(CHlist[ctr].maxstats->hp)
				Write(fp,"\tmax_hp\t\t%d\n",CHlist[ctr].maxstats->hp);
			if(CHlist[ctr].stats->dex)
				Write(fp,"\tdexterity\t%d\n",CHlist[ctr].stats->dex);
			if(CHlist[ctr].maxstats->dex)
				Write(fp,"\tmax_dexterity\t%d\n",CHlist[ctr].maxstats->dex);
			if(CHlist[ctr].stats->str)
				Write(fp,"\tstrength\t%d\n",CHlist[ctr].stats->str);
			if(CHlist[ctr].maxstats->str)
				Write(fp,"\tmax_strength\t%d\n",CHlist[ctr].maxstats->str);
			if(CHlist[ctr].stats->intel)
				Write(fp,"\tintelligence\t%d\n",CHlist[ctr].stats->intel);
			if(CHlist[ctr].maxstats->intel)
				Write(fp,"\tmax_intelligence\t%d\n",CHlist[ctr].maxstats->intel);

			Write(fp,"\tweight\t\t%d\n",CHlist[ctr].stats->weight);

			if(CHlist[ctr].stats->damage)
				Write(fp,"\tdamage\t\t%d\n",CHlist[ctr].stats->damage);
			if(CHlist[ctr].maxstats->damage)
				Write(fp,"\tmax_damage\t%d\n",CHlist[ctr].maxstats->damage);
			if(CHlist[ctr].stats->armour)
				Write(fp,"\tarmour\t\t%d\n",CHlist[ctr].stats->armour);
			if(CHlist[ctr].maxstats->armour)
				Write(fp,"\tmax_armour\t%d\n",CHlist[ctr].maxstats->armour);
			if(CHlist[ctr].stats->karma)
				Write(fp,"\tkarma\t\t%d\n",CHlist[ctr].stats->karma);
			if(CHlist[ctr].stats->bulk)
				Write(fp,"\tbulk\t\t%d\n",CHlist[ctr].stats->bulk);
			if(CHlist[ctr].maxstats->bulk)
				Write(fp,"\tmax_bulk\t%d\n",CHlist[ctr].maxstats->bulk);
			if(CHlist[ctr].light)
				Write(fp,"\tlight\t\t%d\n",CHlist[ctr].light);
			if(CHlist[ctr].stats->range)
				Write(fp,"\trange\t\t%d\n",CHlist[ctr].stats->range);
			if(CHlist[ctr].maxstats->range)
				Write(fp,"\tmax_range\t%d\n",CHlist[ctr].maxstats->range);
			if(CHlist[ctr].maxstats->speed)
				Write(fp,"\tspeed\t%d\n",CHlist[ctr].maxstats->speed);
			if(CHlist[ctr].stats->level)
				Write(fp,"\tlevel\t%d\n",CHlist[ctr].stats->level);
			if(CHlist[ctr].stats->radius)
				if(CHlist[ctr].stats->radius == EggDistance)
					Write(fp,"\tproximity\n");
				else
					Write(fp,"\tradius\t\t%d\n",CHlist[ctr].stats->radius);

			Write(fp,"\tdescription\t\"%s\"\n",CHlist[ctr].desc);
			Write(fp,"\tshort\t\t\"%s\"\n",CHlist[ctr].shortdesc);

			if(CHlist[ctr].funcs->ucache != -1)
				Write(fp,"\tIfUsed\t\t%s\n",CHlist[ctr].funcs->use);
			if(CHlist[ctr].funcs->scache != -1)
				Write(fp,"\tIfTriggered\t%s\n",CHlist[ctr].funcs->stand);
			if(CHlist[ctr].funcs->kcache != -1)
				Write(fp,"\tIfKilled\t%s\n",CHlist[ctr].funcs->kill);
			if(CHlist[ctr].funcs->lcache != -1)
				Write(fp,"\tIfLookedAt\t%s\n",CHlist[ctr].funcs->look);
			if(CHlist[ctr].funcs->hcache != -1)
				Write(fp,"\tIfHurt\t\t%s\n",CHlist[ctr].funcs->hurt);
			if(CHlist[ctr].funcs->icache != -1)
				Write(fp,"\tOnInit\t\t%s\n",CHlist[ctr].funcs->init);
			if(CHlist[ctr].funcs->wcache != -1)
				Write(fp,"\tIfWielded\t%s\n",CHlist[ctr].funcs->wield);
			if(CHlist[ctr].funcs->acache != -1)
				Write(fp,"\tAttack\t\t%s\n",CHlist[ctr].funcs->attack);
			if(CHlist[ctr].funcs->hrcache != -1)
				Write(fp,"\tifhorrified\t%s\n",CHlist[ctr].funcs->horror);

			if(CHlist[ctr].activity > 0)
				Write(fp,"\tbehaviour\t %s\n",PElist[CHlist[ctr].activity].name);

			if(CHlist[ctr].flags.solid)
				Write(fp,"\tsolid\n");
			if(CHlist[ctr].flags.willopen)
				Write(fp,"\twill_open\n");
//        if(CHlist[ctr].flags.rangeweapon)
//            Write(fp,"\tranged_weapon\n");
        if(CHlist[ctr].flags.blocklight && !CHlist[ctr].flags.window)
            Write(fp,"\tblockslight\n");
        if(CHlist[ctr].flags.window)
            Write(fp,"\twindow\n");
        if(CHlist[ctr].flags.invisible && !CHlist[ctr].flags.shadow)
            Write(fp,"\tinvisible\n");
        if(CHlist[ctr].flags.invisible && CHlist[ctr].flags.shadow)
            Write(fp,"\thidden\n");
        if(CHlist[ctr].flags.system)
            Write(fp,"\tsystem\n");
        if(CHlist[ctr].flags.translucent)
            Write(fp,"\ttranslucent\n");
        if(CHlist[ctr].flags.fixed)
            Write(fp,"\tfixed\n");
        if(CHlist[ctr].flags.container)
            Write(fp,"\tcontainer\n");
        if(CHlist[ctr].flags.wield)
            Write(fp,"\twielded\n");
        if(CHlist[ctr].flags.tabletop)
            Write(fp,"\ttabletop\n");
        if(CHlist[ctr].flags.fragile)
            Write(fp,"\tfragile\n");
        if(CHlist[ctr].flags.spikeproof)
            Write(fp,"\tspikeproof\n");
        if(CHlist[ctr].flags.person)
            Write(fp,"\tperson\n");
        if(CHlist[ctr].flags.quantity)
            {
            if(CHlist[ctr].stats->quantity > 1)
                Write(fp,"\tquantity %d\n",CHlist[ctr].stats->quantity);
            else
                Write(fp,"\tquantity\n");
            }
        if(CHlist[ctr].flags.watery)
            Write(fp,"\tboat\n");
        if(CHlist[ctr].flags.shadow)
            Write(fp,"\tshadow\n");
        if(CHlist[ctr].flags.decor)
            Write(fp,"\tdecorative\n");
        if(CHlist[ctr].flags.horror)
            Write(fp,"\thorrific\n");

        if(strlen(CHlist[ctr].funcs->talk) > 1)
            Write(fp,"\tConversation\t%s\n",CHlist[ctr].funcs->talk);

        if(strlen(CHlist[ctr].funcs->user1) > 1)
            Write(fp,"\tuser1\t%s\n",CHlist[ctr].funcs->user1);

        if(strlen(CHlist[ctr].funcs->user2) > 1)
            Write(fp,"\tuser2\t%s\n",CHlist[ctr].funcs->user2);

        for(ctr2=0;ctr2<CHlist[ctr].funcs->contents;ctr2++)
            Write(fp,"\tcontains\t%s\n",CHlist[ctr].funcs->contains[ctr2]);

        // Print resurrection state, if not same as name
//        boot2("cmp '%s'%s'\n",CHlist[ctr].funcs->resurrect,CHlist[ctr].name);
        if(stricmp(CHlist[ctr].funcs->resurrect,CHlist[ctr].name))
            {
            // If resurrection state is just "-", use no_resurrect flag
            if(!stricmp(CHlist[ctr].funcs->resurrect,"-") || !CHlist[ctr].funcs->resurrect[0])
                Write(fp,"\tno_resurrect\n");
            else
                Write(fp,"\tresurrect_as\t%s\n",CHlist[ctr].funcs->resurrect);
            }

        // NPC flags

        if(CHlist[ctr].stats->npcflags.female)
            Write(fp,"\tfemale\n");
        else
            if(CHlist[ctr].flags.person)        // We don't need to say this
                Write(fp,"\tmale\n");         // but it's aesthetic

        if(CHlist[ctr].stats->npcflags.know_name)
            Write(fp,"\tknow_name\n");
        if(CHlist[ctr].stats->npcflags.is_hero)
            Write(fp,"\tis_hero\n");
        if(CHlist[ctr].stats->npcflags.cant_eat)
            Write(fp,"\tcant_eat\n");
        if(CHlist[ctr].stats->npcflags.no_shutdoor)
            Write(fp,"\twont_shut_doors\n");
        if(CHlist[ctr].stats->npcflags.symlink)
            Write(fp,"\tlink_to_other_npc\n");
        if(CHlist[ctr].stats->npcflags.biological)
            Write(fp,"\tbiological\n");
        if(CHlist[ctr].stats->npcflags.guard)
            Write(fp,"\tguard\n");
        if(CHlist[ctr].stats->npcflags.spawned)
            Write(fp,"\tspawned\n");

		if(CHlist[ctr].labels)
			{
			if(CHlist[ctr].labels->race[0])
				Write(fp,"\trace\t\t%s\n",CHlist[ctr].labels->race);
			if(CHlist[ctr].labels->rank[0])
				Write(fp,"\trank\t\t%s\n",CHlist[ctr].labels->rank);
			}

        // Size

        if(CHlist[ctr].vblock[BLK_W] && CHlist[ctr].vblock[BLK_H])
            Write(fp,"\tsetsolid\tV %d %d %d %d\n",CHlist[ctr].vblock[BLK_X],CHlist[ctr].vblock[BLK_Y],CHlist[ctr].vblock[BLK_W],CHlist[ctr].vblock[BLK_H]);
        if(CHlist[ctr].hblock[BLK_W] && CHlist[ctr].hblock[BLK_H])
            Write(fp,"\tsetsolid\tH %d %d %d %d\n",CHlist[ctr].hblock[BLK_X],CHlist[ctr].hblock[BLK_Y],CHlist[ctr].hblock[BLK_W],CHlist[ctr].hblock[BLK_H]);

        if(CHlist[ctr].varea[BLK_W] && CHlist[ctr].varea[BLK_H])
            Write(fp,"\tsetActiveArea\tV %d %d %d %d\n",CHlist[ctr].varea[BLK_X],CHlist[ctr].varea[BLK_Y],CHlist[ctr].varea[BLK_W],CHlist[ctr].varea[BLK_H]);
        if(CHlist[ctr].harea[BLK_W]&& CHlist[ctr].harea[BLK_H])
            Write(fp,"\tsetActiveArea\tH %d %d %d %d\n",CHlist[ctr].harea[BLK_X],CHlist[ctr].harea[BLK_Y],CHlist[ctr].harea[BLK_W],CHlist[ctr].harea[BLK_H]);
        Write(fp,"\n");
        }
    Write(fp,"\n");
    }

// Write Tiles

if(TItot>0)
    {
    Write(fp,"section: tiles\n\n");
    for(ctr=0;ctr<=TItot;ctr++)
    if(TIlist[ctr].name)
        {
        Write(fp,"\tname %s\n",TIlist[ctr].name);
        Write(fp,"\tsequence\t%s\n",TIlist[ctr].seqname);
        Write(fp,"\tdescription\t\"%s\"\n",TIlist[ctr].desc);

        if(TIlist[ctr].flags.solid)
            Write(fp,"\tsolid\n");
        if(TIlist[ctr].flags.blocklight)
            Write(fp,"\tblockslight\n");
        if(TIlist[ctr].flags.watery)
            Write(fp,"\twater\n");
        if(TIlist[ctr].flags.shadow)
            Write(fp,"\tshadow\n");

        if(TIlist[ctr].sdx != 0 || TIlist[ctr].sdy)
            Write(fp,"\tscroll %d %d\n",TIlist[ctr].sdx,TIlist[ctr].sdy);

        if(TIlist[ctr].cost > 1)
            Write(fp,"\tcost %d\n",TIlist[ctr].cost);

		if(TIlist[ctr].alternate)
			for(ctr2=0;ctr2<16;ctr2++)
				if(TIlist[ctr].alternate[ctr2] != TIlist[ctr].form)
					{
					Write(fp,"\tblank ");
					if(ctr2&1)
						Write(fp,"L");
					if(ctr2&2)
						Write(fp,"R");
					if(ctr2&4)
						Write(fp,"U");
					if(ctr2&8)
						Write(fp,"D");
					Write(fp," %s\n",TIlist[ctr].alternate[ctr2]->name);
					}

        Write(fp,"\n");
        }
    Write(fp,"\n");
    }

// Write Sounds

if(Waves>0)
    {
    Write(fp,"section: sounds\n\n");
    for(ctr=0;ctr<Waves;ctr++)
    if(wavtab[ctr].name && wavtab[ctr].fname)
        {
        tabs(str,wavtab[ctr].name);
        if(wavtab[ctr].nodrift)
            Write(fp,"\t%s%s%s  nodrift\n",wavtab[ctr].name,str,wavtab[ctr].fname);
        else
            Write(fp,"\t%s%s%s\n",wavtab[ctr].name,str,wavtab[ctr].fname);
        }
    Write(fp,"\n\n");
    }

// Write Music

if(Songs>0)
    {
    Write(fp,"section: music\n\n");
    for(ctr=0;ctr<Songs;ctr++)
    if(mustab[ctr].name && mustab[ctr].fname)
        {
        tabs(str,mustab[ctr].name);
        if(mustab[ctr].loopsong)
	        Write(fp,"\t%s%s%s  loop\n",mustab[ctr].name,str,mustab[ctr].fname);
		else
	        Write(fp,"\t%s%s%s\n",mustab[ctr].name,str,mustab[ctr].fname);
        }
    Write(fp,"\n\n");
    }

// Write Roof tiles

if(RTtot>0)
    {
    Write(fp,"section: rooftiles\n\n");
    for(ctr=1;ctr<rft_total;ctr++)
    if(RTlist[ctr].fname)
        {
        tabs(str,RTlist[ctr].fname);
//        memset(str,' ',20);
//        str[20-strlen(RTlist[ctr].fname)]=0;

        Write(fp,"\t%s",RTlist[ctr].fname);
        if(!RTlist[ctr].flags&1)
            Write(fp,"\tstand_under",RTlist[ctr].fname);
		else
			if(RTlist[ctr].flags&2)
				Write(fp,"\tdark",RTlist[ctr].fname);
		Write(fp,"\n");
        }
    Write(fp,"\n\n");
    }

// Write Lightmaps

if(LTtot>0)
	{
	Write(fp,"section: lightmaps\n\n");
	for(ctr=1;ctr<lgt_total;ctr++)
		if(LTlist[ctr].fname)
			Write(fp,"\t%s\n",LTlist[ctr].fname);
	Write(fp,"\n\n");
	}

// Write user scripts

if(pef_alloc>0)
    {
    Write(fp,"section: scripts\n\n");
    for(ctr=0;ctr<pef_alloc;ctr++)
    if(pe_files[ctr])
	Write(fp,"\t%s\n",pe_files[ctr]);
    Write(fp,"\n\n");
    }

// Write Tables

if(DTtot>0)
	{
	Write(fp,"section: tables\n\n");
	for(ctr=0;ctr<tab_alloc;ctr++)
		if(DTlist[ctr].name)
			{
			Write(fp,"\n");
			Write(fp,"\tname %s\n",DTlist[ctr].name);

			if(DTlist[ctr].keytype == 'i')
				Write(fp,"\tkey=integer\n");
			if(DTlist[ctr].keytype == 's')
				Write(fp,"\tkey=string\n");
			if(DTlist[ctr].listtype == 'i')
				Write(fp,"\tdata=integer\n");
			if(DTlist[ctr].listtype == 's')
				Write(fp,"\tdata=string\n");

			Write(fp,"\tlist:\n");
			for(ctr2=0;ctr2<DTlist[ctr].entries;ctr2++)
				{
				Write(fp,"\t\t");
				if(DTlist[ctr].keytype == 'i')
					Write(fp,"%d ",DTlist[ctr].list[ctr2].ki);
				if(DTlist[ctr].keytype == 's')
					Write(fp,"%s ",DTlist[ctr].list[ctr2].ks);
				if(DTlist[ctr].listtype == 'i')
					Write(fp,"%d ",DTlist[ctr].list[ctr2].ii);
				if(DTlist[ctr].listtype == 's')
					Write(fp,"%s ",DTlist[ctr].list[ctr2].is);
				Write(fp,"\n");
				}
			Write(fp,"\tend\n");
			}
	Write(fp,"\n");
	Write(fp,"\n");
	}

if(TLtot>0)
	{
	Write(fp,"section: tilelink\n\n");
	for(ctr=1;ctr<TLtot;ctr++)
		{
		Write(fp,"\tname %s\n",TLlist[ctr].name);
		Write(fp,"\ttile %s\n",TIlist[TLlist[ctr].tile].name);
		for(c=0;c<TLlist[ctr].nt;c++)
			Write(fp,"\tn %s\n",TLlist[TLlist[ctr].n[c].tile].name);
		for(c=0;c<TLlist[ctr].st;c++)
			Write(fp,"\ts %s\n",TLlist[TLlist[ctr].s[c].tile].name);
		for(c=0;c<TLlist[ctr].et;c++)
			Write(fp,"\te %s\n",TLlist[TLlist[ctr].e[c].tile].name);
		for(c=0;c<TLlist[ctr].wt;c++)
			Write(fp,"\tw %s\n",TLlist[TLlist[ctr].w[c].tile].name);
		for(c=0;c<TLlist[ctr].net;c++)
			Write(fp,"\tne %s\n",TLlist[TLlist[ctr].ne[c].tile].name);
		for(c=0;c<TLlist[ctr].nwt;c++)
			Write(fp,"\tnw %s\n",TLlist[TLlist[ctr].nw[c].tile].name);
		for(c=0;c<TLlist[ctr].set;c++)
			Write(fp,"\tse %s\n",TLlist[TLlist[ctr].se[c].tile].name);
		for(c=0;c<TLlist[ctr].swt;c++)
			Write(fp,"\tsw %s\n",TLlist[TLlist[ctr].sw[c].tile].name);
		Write(fp,"\n");
		}
	Write(fp,"\n");
	}

fclose(fp);
}


/*
 *      Write the data to file
 */

void Write(FILE *fp,char *msg, ...)
{
char buffer[1024];
va_list ap;

// OK, let's kick ass

va_start(ap, msg);
vsprintf(buffer,msg,ap);
fputs(buffer,fp);

va_end(ap);
}

/*
 *      Calculate number of tabs for the output
 */

void tabs(char *tabbuf,char *msg)
{
int len;
len = strlen(msg);

strcpy(tabbuf,"\t\t\t");

if(len>7)
    tabbuf[2]=0;
if(len>15)
    tabbuf[1]=0;
}

// Dummy variables


void RFS_getescape()
{
while((readkey() >> 8) != KEY_ESC);
}



