//
//	RAR.C - Load files from RAR archives
//

#include <allegro.h>	// Emulates strlwr

// We need ACCESS and R_OK
#ifndef _WIN32
#include <unistd.h>
#else
#include <io.h>
#endif

#include <string.h>

#include "ithelib.h"

// Defines

struct rarblock
	{
	unsigned short head_crc;
	unsigned char  head_type;
	unsigned short head_flags;
	unsigned short head_size;
	unsigned long  additional_size;
	};

struct fileblock
	{
	unsigned long  unpacked_size;
	unsigned char  host_os;
	unsigned long  crc;
	unsigned long  time;
	unsigned char  version;
	unsigned char  method;
	unsigned short name_size;
	unsigned long  attr;
	unsigned long  offset;
	};

// Variables

static char filebuf[2048];

// Functions

static void rar_readblock(IFILE *fp, struct fileblock *f);
static int rar_getheader(IFILE *fp,struct rarblock *r);
static void rar_getfile(IFILE *fp, struct fileblock *f);

// Code


/*
 *    get_rarheader - read the generic header block
 */

int rar_getheader(IFILE *fp,struct rarblock *r)
{
int curpos;
curpos = itell(fp);

r->head_crc = igetsh_i(fp);
r->head_type = igetc(fp);
r->head_flags = igetsh_i(fp);
r->head_size = igetsh_i(fp);
if(r->head_flags & 0x8000)
	r->additional_size = igetl_i(fp);
else
	r->additional_size = 0;

return curpos+r->head_size;
}


/*
 *    get_file - read the FILE header block
 */

void rar_getfile(IFILE *fp, struct fileblock *f)
{
f->unpacked_size = igetl_i(fp);
f->host_os = igetc(fp);
f->crc = igetl_i(fp);
f->time = igetl_i(fp);
f->version = igetc(fp);
f->method = igetc(fp);
f->name_size = igetsh_i(fp);
f->attr = igetl_i(fp);
}


/*
 *    rar_readblock - read the RAR file blocks and decide what to do
 */

void rar_readblock(IFILE *fp, struct fileblock *f)
{
int nextpos;
struct rarblock r;

nextpos = rar_getheader(fp,&r); // File position to jump to when we're done

filebuf[0]=0; // Clear filename buffer

switch(r.head_type)
	{
	case 0x74:
	rar_getfile(fp,f);

	iread(filebuf,f->name_size,fp);
	filebuf[f->name_size]=0;
//	printf("'%s' : %d : m%02x\n",mmmmm,f.name_size,f.method);
//	iseek(fp,nextpos,SEEK_SET);
	f->offset = nextpos;
	// Seek next block
	iseek(fp,nextpos+r.additional_size,SEEK_SET);
	break;

	default:
	iseek(fp,nextpos+r.additional_size,SEEK_SET);
	break;
	}

return;
}


/*
 *    check_rar_file - Make sure the RAR file is usable
 */

int check_rar_file(char *filename)
{
IFILE *fp;
struct fileblock f;
char rarsig[]={0,0,0,0,0};
char fname[1024];

strcpy(fname,filename);

if(access(fname,R_OK))
	return -1;

fp = iopen(fname);
iread(rarsig,4,fp);
if(strcmp(rarsig,"Rar!"))
	return -2;
iseek(fp,0,SEEK_SET);

do
	{
	rar_readblock(fp,&f);
	if(filebuf[0])
		if(f.method != 0x30)
			{
			iclose(fp);
			return -3;
			}
	} while(!ieof(fp));
iclose(fp);

return 0;
}


/*
 *    scan_rar_file - Mount the RAR file and the data within
 */

void scan_rar_file(char *filename)
{
IFILE *fp;
struct fileblock f;
char rarsig[4];
char *tbuf,*truename;
int ok;
char fname[1024];

strcpy(fname,filename);

// First check for no RAR file

if(access(fname,R_OK))
	return;

// Open and check for bad RAR file
fp = iopen(fname);
iread(rarsig,4,fp);
if(!strcmp(rarsig,"Rar!"))
	{
	iclose(fp);
	return;
	}
iseek(fp,0,SEEK_SET);

// Store the RAR file's true name

truename = M_get(1,strlen(fname)+1);
strcpy(truename,fname);

// Ok, we're clean, let's do it

ok=0;

do
	{
	rar_readblock(fp,&f);
	if(filebuf[0])
		{
		strlwr(filebuf);
		strslash(filebuf);
		tbuf = (char *)M_get(1,strlen(filebuf)+1);
		strcpy(tbuf,filebuf); // Store filename
		if(!ifile_attach(tbuf,truename,f.unpacked_size,f.offset))
			M_free(tbuf); // Not added, free the pointer
		else
			ok=1;
		}
	} while(!ieof(fp));

if(!ok)
	M_free(truename);	// Prevent orphaned pointer if totally unsuccessful
iclose(fp);
}

