#ifndef __pluginh__
  #include "../plugin.h"
#endif
#ifndef __errorh__
  #include "../error.h"
#endif
#ifndef __polytypeh__
  #include "../polytype.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoFrancaisMod :public Plugin{
public:
  dsoFrancaisMod();
  virtual void Init();
private:
  static void DAYNAME(__HITOPFUNC__);
  static void MONTHNAME(__HITOPFUNC__);
  static void DAYSHORTNAME(__HITOPFUNC__);
  static void MONTHSHORTNAME(__HITOPFUNC__);
  static void DAYABBREV(__HITOPFUNC__);
  static void MONTHABBREV(__HITOPFUNC__);
};

static dsoFrancaisMod initmodule;

static const string daynames[]={"dimanche","lundi","mardi","mecredi","jeudi",
  "vendredi","samedi"};
static const string monthnames[]={"janvier","f&eacute;vrier","mars","avril",
  "mai","juin","juillet","ao&ucircum;t","septembre","octobre","novembre",
  "d&eacute;cembre"};
static const string dayshortnames[]={"dim","lun","mar","mec","jeu","ven",
  "sam"};
static const string monthshortnames[]={"jan","f&eacute;v","mar","avr",
  "mai","jun","jui","ao&ucircum;","sep","oct","nov","d&eacute;c"};
static const string dayabbrevs[]={"d","d","ma","me","j","v","s"};
static const string monthabbrevs[]={"jan","f&eacute;v","mar","avr",
  "mai","jun","jui","ao&ucircum;","sep","oct","nov","d&eacute;c"};

dsoFrancaisMod::dsoFrancaisMod() {
  RegisterPlugin(string("francais"),1);
}

void dsoFrancaisMod::Init(){
  SetNamespace("FRANCAIS");
  RegisterFunction("DAYNAME",&DAYNAME);
  RegisterFunction("MONTHNAME",&MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&DAYABBREV);
  RegisterFunction("MONTHABBREV",&MONTHABBREV);
}

void dsoFrancaisMod::DAYNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[data.AsInt()%7];
}

void dsoFrancaisMod::MONTHNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(data.AsInt()-1)%12];
}

void dsoFrancaisMod::DAYSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[data.AsInt()%7];
}

void dsoFrancaisMod::MONTHSHORTNAME(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(data.AsInt()-1)%12];
}

void dsoFrancaisMod::DAYABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[data.AsInt()%7];
}

void dsoFrancaisMod::MONTHABBREV(__HITOPFUNC__){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(data.AsInt()-1)%12];
}
