/* $Log: options.h,v $
/* Revision 1.2  2004/10/25 16:36:08  emery
/* Ritual update.
/*
/* Revision 1.1  2003/10/15 15:58:59  emery
/* Initial check-in.
/*
/* Revision 1.2  2003/05/08 21:42:29  emery
/* Ritual check-in.
/*
/* Revision 1.1  2001/08/23 17:20:11  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:18  dgay
/* Initial import of RC tests
/*
 * Revision 1.7  1997/02/22 22:40:26  arda
 * Port to Solaris
 * Print error trace for compiled code
 * Fix a lurking bug in bvarargs
 *
 * Revision 1.6  1996/07/07 22:35:11  arda
 * Abolished send_to_char
 * Cleaned up object handling, removed dynpro's from objects
 * Cleaned up lanterns, added covering lanterns and associated visibility
 * changes
 * Misc. hardcode fixes
 *
 * Revision 1.5  1996/07/04 00:31:20  arda
 * Simple stuff, mostly.
 *
 * Revision 1.4  1996/05/14 22:13:11  arda
 * Misc. small changes.
 *
 * Revision 1.3  1996/02/09 14:58:45  arda
 * Security holes
 *
 * Revision 1.2  1995/07/16  09:16:52  arda
 * Add GCSTATS option.
 * Misc bug fixes.
 *
 * Revision 1.1  1995/07/15  15:49:29  arda
 * New files, missing from previous commit.
 *
 */

#ifndef OPTIONS_H
#define OPTIONS_H

/* Mudlle configuration */
/* This files contains only #define's, it is used for both C and assembly code */


/* EDB */
#define PRINT_CODE
#define INLINE
#define INTERRUPT
#define HAVE_MEMMOVE
#include <string.h>
#define stricmp strcasecmp



#ifndef MUME
/* The MUME options are in ../config.h */

#if 0 // def sparc
#define PRINT_CODE
#define INLINE
#define INTERRUPT
#ifdef __SVR4
#define HAVE_MEMMOVE
#define stricmp strcasecmp
#endif
#endif


#ifdef _WIN32
#define PRINT_CODE
#define INLINE
#define INTERRUPT
#define HAVE_MEMMOVE
#include <string.h>
#define stricmp _stricmp
#endif


#ifdef hpux
#define stricmp strcasecmp
#define PRINT_CODE
#define INLINE
#define INTERRUPT
#define HAVE_MEMMOVE
#define NOCOMPILER
#endif

#ifdef __sgi
#include <sys/bsd_types.h>
#define HAVE_ULONG
#define stricmp strcasecmp
#define PRINT_CODE
#define INLINE
#define INTERRUPT
#define HAVE_MEMMOVE
#define NOCOMPILER
#endif

#ifdef linux
#include <sys/types.h>
#define HAVE_ULONG
#define stricmp strcasecmp
#define HAVE_MEMMOVE
#define PRINT_CODE
#define INLINE
#define GCDEBUG
#define GCDEBUG_CHECK
#define PRINT_CODE
#define INTERRUPT
#define NOCOMPILER
#define HAVE_ALLOCA_H
#endif

#ifdef AMIGA
#define PRINT_CODE
#define INLINE __inline
#define HAVE_MEMMOVE
#define PRINT_CODE
#define INTERRUPT
#define HAVE_ALLOCA_H
#endif

#define PATH_MAX 1024

/* GC configuration, basic parameters */
/* More parameters are found in alloc.h (and some logic in alloc.c). */

#define INITIAL_BLOCKSIZE (1024*1024)
#define DEF_SAVE_SIZE (64*1024)
#define GLOBAL_SIZE 512
#define DEFAULT_SECLEVEL 0

#endif


/* Define NORETURN as a qualifier to indicate that a function never returns.
   With gcc, this is `volatile'. The empty definition is ok too. */
#ifdef _gcc
#define NORETURN volatile
#else
#define NORETURN
#endif


#ifdef __SVR4
#define __EXTENSIONS__
#define HAVE_ULONG
#include <sys/types.h>
#define HAVE_ALLOCA_H
#define nosigsetjmp setjmp
#define nosiglongjmp longjmp
#else
#define HAVE_ALLOCA_H
#define nosigsetjmp _setjmp
#define nosiglongjmp _longjmp
#define HAVE_TM_ZONE
#endif

#define NOCOMPILER

#ifdef _WIN32
#define NOCOMPILER
#define nosigsetjmp setjmp
#define nosiglongjmp longjmp
#endif


#ifdef hpux
#define stricmp strcasecmp
#define HAVE_MEMMOVE
#define NOCOMPILER
#define nosigsetjmp setjmp
#define nosiglongjmp longjmp
#endif

#ifdef __sgi
#include <sys/bsd_types.h>
#define HAVE_ULONG
#define HAVE_MEMMOVE
#define NOCOMPILER
#define HAVE_ALLOCA_H
#define nosigsetjmp setjmp
#define nosiglongjmp longjmp
#endif

#ifdef linux
#include <sys/types.h>
#define HAVE_ULONG
#define stricmp strcasecmp
#define HAVE_MEMMOVE
#define NOCOMPILER
#define HAVE_ALLOCA_H
#define nosigsetjmp _setjmp
#define nosiglongjmp _longjmp
#endif

#ifdef AMIGA
#define HAVE_MEMMOVE
#define HAVE_ALLOCA_H
#define HAVE_TM_ZONE
#define nosigsetjmp setjmp
#define nosiglongjmp longjmp
#endif

#undef GCSTATS

/* Execution limits */

#define MAX_CALLS 10000		/* Max # of calls executed / interpret */

#define MAX_FAST_CALLS 100000	/* Max # of faster calls (machine code) */


#endif
