// This may look like C code, but it is really -*- C++ -*-

// sched.h
// -------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Class definition of time scheduler for simulation

#ifndef SCHED_DEF
#define SCHED_DEF 0

#include "machine.h"

#ifdef DOMESG
#define TRACE message_trace_switch
#else /* DOMESG */
#define TRACE 0
#endif /* DOMESG */

#ifdef DOSCHED
#define SCHEDTRACE 1
#else /* DOSCHED */
#define SCHEDTRACE 0
#endif /* DOSCHED */

struct message;
#ifdef REFGC
typedef Ref<struct message> MessagePtr;
typedef SRef<struct message> SMessagePtr;
#else
typedef struct message* MessagePtr;
typedef struct message* SMessagePtr;
#endif

enum EventType { PM, INT };

struct ActArg {
    MessagePtr pm;
    int i;
    void operator=(const int ii) { i = ii; }
    void operator=(const MessagePtr pm2) { pm = pm2; }
    void operator=(const ActArg &ar) { pm = ar.pm; i = ar.i;}
    ActArg() {}
};

#ifdef CASTINT
typedef const int ActArgT;
#else
typedef const ActArg& ActArgT;
#endif

typedef void (*IntAction)(const int);	// our basic kind of function
typedef void (*PMAction)(const SMessagePtr);	// our basic kind of function

typedef unsigned long  timetype;	// nanosecond ticks of time
typedef timetype delta;		// between two times


struct event {
  EventType tag;
//  union {
    IntAction iact;
    PMAction pmact;
//  };

  ActArg arg;

  timetype time;		// at clock== time, call act(arg)
//  event() : tag(INT) {};
  event();
};

#define HEAP_SIZE (4 * MAX_CUBE_SIZE)
struct heap {
	event events[ HEAP_SIZE + 1 ];
	int numevents;			// 1..numevents occupied, 0 ignored
	heap();
};
struct linkedlist {
#ifdef REFGC
  Ref<linkedlist> next;
#else
  struct linkedlist *next;
#endif
  struct event thisevent;
  linkedlist() {}
};

#ifdef REFGC
typedef Ref<linkedlist> LinkedListPtr;
#else
typedef struct linkedlist *LinkedListPtr;
#endif

class schedulerclass {		// Only one instance will exist
	heap eventq;		// events at various future times
	long eventscount;	// # of events performed
	int highwater;		// # in eventq at once
  public:
	timetype clock;		// "now" in hardware ticks
	schedulerclass();	// init

	// At clock+delta, we will invoke action(int). Goes on event q.
	void post( IntAction, const int, delta );
	void post( PMAction, const SMessagePtr, delta );

	void run();				// Start up.
	void print( char* );			// Show stats
};

#endif /* SCHED_DEF */


