#ifndef _IGNOREINVALIDFREE_H_
#define _IGNOREINVALIDFREE_H_

#include "hldefines.h"

// A class that checks to see if the object to be freed is inside a
// valid superblock. If not, it drops the object on the floor. We do
// this in the name of robustness (turning a segfault or data
// corruption into a potential memory leak) and because on some
// systems, it's impossible to catch the first few allocated objects.

template <class S>
class IgnoreInvalidFree : public S {
public:
  INLINE void free (void * ptr) {
    typename S::SuperblockType * s = S::getSuperblock (ptr);
    if (!s || (!s->isValidSuperblock()))
      return;
    S::free (ptr);
  }

  INLINE size_t getSize (void * ptr) {
    typename S::SuperblockType * s = S::getSuperblock (ptr);
    if (!s || (!s->isValidSuperblock()))
      return 0;
    return S::getSize (ptr);
  }

};

#endif
