//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: SurfaceMeshOfQuadrangles.hpp,v 1.6 2004/05/31 18:49:32 delpinux Exp $

#ifndef SURFACE_MESH_OF_QUADRANGLES_HPP
#define SURFACE_MESH_OF_QUADRANGLES_HPP

#include <Vector.hpp>
#include <Quadrangle.hpp>

#include <SurfaceMesh.hpp>

class SurfaceMeshOfQuadrangles
  : public SurfaceMesh
{
public:
  typedef Quadrangle ElementGeometry;

  typedef struct {} BorderMeshType; /**< BorderMeshType is not defined  */

  typedef Mesh::T_iterator<SurfaceMeshOfQuadrangles, Quadrangle> iterator;
  typedef Mesh::T_iterator<const SurfaceMeshOfQuadrangles, const Quadrangle> const_iterator;

private:
  ReferenceCounting<Vector<Quadrangle> > __cells;

public:
  //! Returns \p true if the point \a p is inside the mesh.
  inline bool inside(const real_t& x, const real_t& y, const real_t& z) const
  {
    fferr(0) << "Trying to find 3d point on a surface mesh\n";
    std::exit(1);
    return true;
  }

  //! Returns \p true if the point \a p is inside the mesh.
  inline bool inside(const TinyVector<3>& p) const
  {
    return this->inside(p[0], p[1], p[2]);
  }  

  void computesFictitiousCells() const
  {
    this->__computesFictitiousCells<Quadrangle>(*__cells);
  }

  void plotOpenDX(std::ostream& os, const std::string& s) const
  {
    fferr(2) << __FILE__ << ':' << __LINE__ << ": Not implemented\n";
    std::exit(1);
  }

  Quadrangle& cell(size_t i)
  {
    return (*__cells)[i];
  }

  const Quadrangle& cell(size_t i) const
  {
    return (*__cells)[i];
  }

  size_t cellNumber(const Quadrangle& c) const
  {
    return (*__cells).number(c);
  }

  //! Reserves storage for \a n SurfElem.
  inline void setNumberOfCells(const int n)
  {
    (*__cells).resize(n);
  }

  //! Read-only access to the number of cells.
  inline const size_t& numberOfCells() const
  {
    return (*__cells).size();
  }

  SurfaceMeshOfQuadrangles(const size_t theNumberOfCells)
    : SurfaceMesh(Mesh::surfaceMeshQuadrangles),
      __cells(new Vector<Quadrangle>(theNumberOfCells))
  {
    ;
  }

  SurfaceMeshOfQuadrangles(ReferenceCounting<VerticesSet> vertices,
			   ReferenceCounting<Vector<Quadrangle> > quadrangles)
    : SurfaceMesh(Mesh::surfaceMeshQuadrangles,
		  vertices),
      __cells(quadrangles)
  {
    ;
  }

  SurfaceMeshOfQuadrangles()
    : SurfaceMesh(Mesh::surfaceMeshQuadrangles)
  {
    ;
  }

  ~SurfaceMeshOfQuadrangles()
  {
    ;
  }
};

#endif // SURFACE_MESH_OF_QUADRANGLES_HPP

