//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: CellByEdges.hpp,v 1.2 2003/04/26 18:45:15 delpinux Exp $

#ifndef CELLBYEDGES_HPP
#define CELLBYEDGES_HPP

#include<Edge.hpp>

class CellByEdges
{
protected:
  //! Edges list
  Edge **__edges;

public:
  //! Returns the number of edges used
  virtual const size_t numberOfEdges() const = 0;

  Edge& edge(const size_t& i)
  {
    assert(i<numberOfEdges());
    return *__edges[i];
  }

  const Edge& edge(const size_t& i) const
  {
    assert(i<numberOfEdges());
    return *__edges[i];
  }

  //! Constructor
  CellByEdges(const size_t nbE)
  {
    __edges = new Edge*[nbE];
  }

  //! Copy constructor
  CellByEdges(const CellByEdges& C)
  {
    __edges = new Edge*[C.numberOfEdges()];
  }

  //! Destructor
  virtual ~CellByEdges()
  {
    delete [] __edges;
  }
};

#endif // CELLBYEDGES_HPP

