//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: DomainExpression.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#ifndef _DOMAIN_EXPRESSION_HPP_
#define _DOMAIN_EXPRESSION_HPP_

#include <Expression.hpp>
#include <SceneExpression.hpp>
#include <InsideListExpression.hpp>
#include <Variable.hpp>

/*!
  \class DomainExpression

  This class defines the base class of Domain expressions.

  \author Stephane Del Pino
 */
class Domain;
class DomainExpression
  : public Expression
{
protected:
  ReferenceCounting<Domain> __domain;

public:
  enum DomainType {
    undefined,
    set,
    variable
  };

private:
  const DomainExpression::DomainType __domainType;

public:
  ReferenceCounting<Domain> domain() const;

  const DomainExpression::DomainType& domainType() const
  {
    return __domainType;
  }

  DomainExpression(const DomainExpression& e);

  DomainExpression(ReferenceCounting<Domain> m,
		   const DomainExpression::DomainType& t);

  virtual ~DomainExpression();
};

/*!
  \class DomainExpressionSet

  This class defines the class of domain set expressions.

  \author Stephane Del Pino
 */
class DomainExpressionSet
  : public DomainExpression
{
private:
  ReferenceCounting<SceneExpression> __scene;

  ReferenceCounting<InsideListExpression> __definition;

  std::ostream& put(std::ostream& os) const;

public:
  ReferenceCounting<SceneExpression> scene();

  void execute();

  DomainExpressionSet(ReferenceCounting<SceneExpression> s,
		      ReferenceCounting<InsideListExpression> def);

  DomainExpressionSet(const DomainExpressionSet& m);

  ~DomainExpressionSet();
};

class DomainExpressionVariable
  : public DomainExpression
{
private:
  ReferenceCounting<DomainVariable> __domainVariable;

  std::ostream& put(std::ostream& os) const
  {
    os << (*__domainVariable).name() << ": " << (*(*__domainVariable).expression());
    return os;
  }

public:
  void execute();
  ReferenceCounting<DomainExpression> domainExpression() const;

  DomainExpressionVariable(ReferenceCounting<DomainVariable> r);

  DomainExpressionVariable(const DomainExpressionVariable& e);

  ~DomainExpressionVariable();
};

class DomainExpressionUndefined
  : public DomainExpression
{
private:
  std::ostream& put(std::ostream& os) const
  {
    os << "undefined domain";
    return os;
  }

public:

  void execute()
  {
    ;
  }

  DomainExpressionUndefined();

  DomainExpressionUndefined(const DomainExpressionUndefined& m);

  ~DomainExpressionUndefined();
};

#endif // _DOMAIN_EXPRESSION_HPP_

